/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.TextVertexOutputFormat;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class GraphvizOutputFormat
extends TextVertexOutputFormat<WritableComparable, Writable, Writable> {
    private static final String NODE_TEXT_COLOR = "blue:orange";

    @Override
    public TextVertexOutputFormat.TextVertexWriter createVertexWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new VertexWriter();
    }

    @Override
    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new GraphvizOutputCommitter(super.getOutputCommitter(context));
    }

    private static Path getOutputDir(JobContext context) {
        return FileOutputFormat.getOutputPath((JobContext)context);
    }

    private static Path getPathAtBeginning(JobContext context) {
        return new Path(GraphvizOutputFormat.getOutputDir(context), "____" + System.currentTimeMillis());
    }

    private static Path getPathAtEnd(JobContext context) {
        return new Path(GraphvizOutputFormat.getOutputDir(context), "zzz_" + System.currentTimeMillis());
    }

    private static void writeStart(JobContext context) throws IOException {
        Path path = GraphvizOutputFormat.getPathAtBeginning(context);
        FileSystem fs = path.getFileSystem(context.getConfiguration());
        FSDataOutputStream file = fs.create(path, false);
        file.writeBytes("digraph g {\n");
        file.close();
    }

    private static void writeEnd(JobContext context) throws IOException {
        Path path = GraphvizOutputFormat.getPathAtEnd(context);
        FileSystem fs = path.getFileSystem(context.getConfiguration());
        FSDataOutputStream file = fs.create(path, false);
        file.writeBytes("}\n");
        file.close();
    }

    private static void addNodeInfo(Vertex<WritableComparable, Writable, Writable> vertex, StringBuilder sb) {
        sb.append('\"').append(vertex.getId()).append('\"');
        sb.append(" [").append("label=").append('\"').append("<id> ");
        sb.append(vertex.getId());
        if (!(vertex.getValue() instanceof NullWritable)) {
            sb.append("|").append(vertex.getValue());
        }
        sb.append('\"').append(",shape=record,fillcolor=").append('\"').append(NODE_TEXT_COLOR).append('\"').append("];");
    }

    private static void addEdge(StringBuilder sb, Writable sourceID, Edge<WritableComparable, Writable> edge) {
        sb.append(sourceID).append(":id").append(" -> ").append(edge.getTargetVertexId()).append(":id");
        GraphvizOutputFormat.addEdgeInfo(sb, edge);
        sb.append("\n");
    }

    private static void addEdgeInfo(StringBuilder sb, Edge<WritableComparable, Writable> edge) {
        if (!(edge.getValue() instanceof NullWritable)) {
            sb.append(" [label=").append(edge.getValue()).append(" ];");
        }
    }

    private class VertexWriter
    extends TextVertexOutputFormat.TextVertexWriter {
        private VertexWriter() {
            super(GraphvizOutputFormat.this);
        }

        @Override
        public void writeVertex(Vertex<WritableComparable, Writable, Writable> vertex) throws IOException, InterruptedException {
            StringBuilder sb = new StringBuilder(vertex.getNumEdges() * 10);
            for (Edge<WritableComparable, Writable> edge : vertex.getEdges()) {
                GraphvizOutputFormat.addEdge(sb, (Writable)vertex.getId(), edge);
            }
            GraphvizOutputFormat.addNodeInfo(vertex, sb);
            this.getRecordWriter().write((Object)new Text(sb.toString()), null);
        }
    }

    private static class GraphvizOutputCommitter
    extends OutputCommitter {
        private final OutputCommitter delegate;

        private GraphvizOutputCommitter(OutputCommitter delegate) {
            this.delegate = delegate;
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
            this.delegate.abortJob(jobContext, state);
        }

        public void abortTask(TaskAttemptContext taskContext) throws IOException {
            this.delegate.abortTask(taskContext);
        }

        @Deprecated
        public void cleanupJob(JobContext context) throws IOException {
            this.delegate.cleanupJob(context);
        }

        public void commitJob(JobContext jobContext) throws IOException {
            GraphvizOutputFormat.writeEnd(jobContext);
            this.delegate.commitJob(jobContext);
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
            this.delegate.commitTask(taskContext);
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
            return this.delegate.needsTaskCommit(taskContext);
        }

        public void setupJob(JobContext jobContext) throws IOException {
            this.delegate.setupJob(jobContext);
            GraphvizOutputFormat.writeStart(jobContext);
        }

        public void setupTask(TaskAttemptContext taskContext) throws IOException {
            this.delegate.setupTask(taskContext);
        }
    }
}

