/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class GiraphTextOutputFormat
extends TextOutputFormat<Text, Text> {
    public RecordWriter<Text, Text> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        FSDataOutputStream fileOut;
        String extension = "";
        CompressionCodec codec = null;
        Configuration conf = job.getConfiguration();
        boolean isCompressed = GiraphTextOutputFormat.getCompressOutput((JobContext)job);
        if (isCompressed) {
            Class codecClass = GiraphTextOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            extension = codec.getDefaultExtension();
        }
        Path file = this.getDefaultWorkFile(job, extension);
        FileSystem fs = file.getFileSystem(conf);
        String subdir = this.getSubdir();
        if (!subdir.isEmpty()) {
            Path subdirPath = new Path(subdir);
            Path subdirAbsPath = new Path(file.getParent(), subdirPath);
            Path vertexFile = new Path(subdirAbsPath, file.getName());
            fileOut = fs.create(vertexFile, false);
        } else {
            fileOut = fs.create(file, false);
        }
        String separator = "\t";
        if (!isCompressed) {
            return new TextOutputFormat.LineRecordWriter((DataOutputStream)fileOut, separator);
        }
        DataOutputStream out = new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut));
        return new TextOutputFormat.LineRecordWriter(out, separator);
    }

    protected abstract String getSubdir();
}

