/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.InvalidInputException;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Logger;

public abstract class GiraphFileInputFormat<K, V>
extends FileInputFormat<K, V> {
    public static final String VERTEX_INPUT_DIR = "giraph.vertex.input.dir";
    public static final String EDGE_INPUT_DIR = "giraph.edge.input.dir";
    public static final String NUM_VERTEX_INPUT_FILES = "giraph.input.vertex.num.files";
    public static final String NUM_EDGE_INPUT_FILES = "giraph.input.edge.num.files";
    private static final double SPLIT_SLOP = 1.1;
    private static final PathFilter HIDDEN_FILE_FILTER = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };
    private static final Logger LOG = Logger.getLogger(GiraphFileInputFormat.class);

    public static void addVertexInputPath(Configuration conf, Path path) throws IOException {
        String dirStr = GiraphFileInputFormat.pathToDirString(conf, path);
        String dirs = conf.get(VERTEX_INPUT_DIR);
        conf.set(VERTEX_INPUT_DIR, dirs == null ? dirStr : dirs + "," + dirStr);
    }

    public static void setVertexInputPath(Configuration conf, Path path) throws IOException {
        conf.set(VERTEX_INPUT_DIR, GiraphFileInputFormat.pathToDirString(conf, path));
    }

    public static void addEdgeInputPath(Configuration conf, Path path) throws IOException {
        String dirStr = GiraphFileInputFormat.pathToDirString(conf, path);
        String dirs = conf.get(EDGE_INPUT_DIR);
        conf.set(EDGE_INPUT_DIR, dirs == null ? dirStr : dirs + "," + dirStr);
    }

    public static void setEdgeInputPath(Configuration conf, Path path) throws IOException {
        conf.set(EDGE_INPUT_DIR, GiraphFileInputFormat.pathToDirString(conf, path));
    }

    private static String pathToDirString(Configuration conf, Path path) throws IOException {
        path = path.getFileSystem(conf).makeQualified(path);
        return StringUtils.escapeString((String)path.toString());
    }

    public static Path[] getVertexInputPaths(JobContext context) {
        String dirs = context.getConfiguration().get(VERTEX_INPUT_DIR, "");
        String[] list = StringUtils.split((String)dirs);
        Path[] result = new Path[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new Path(StringUtils.unEscapeString((String)list[i]));
        }
        return result;
    }

    public static Path[] getEdgeInputPaths(JobContext context) {
        String dirs = context.getConfiguration().get(EDGE_INPUT_DIR, "");
        String[] list = StringUtils.split((String)dirs);
        Path[] result = new Path[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new Path(StringUtils.unEscapeString((String)list[i]));
        }
        return result;
    }

    private List<FileStatus> listStatus(JobContext job, Path[] dirs) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<IOException> errors = new ArrayList<IOException>();
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
        filters.add(HIDDEN_FILE_FILTER);
        PathFilter jobFilter = GiraphFileInputFormat.getInputPathFilter((JobContext)job);
        if (jobFilter != null) {
            filters.add(jobFilter);
        }
        MultiPathFilter inputFilter = new MultiPathFilter(filters);
        for (Path p : dirs) {
            FileSystem fs = p.getFileSystem(job.getConfiguration());
            FileStatus[] matches = fs.globStatus(p, (PathFilter)inputFilter);
            if (matches == null) {
                errors.add(new IOException("Input path does not exist: " + p));
                continue;
            }
            if (matches.length == 0) {
                errors.add(new IOException("Input Pattern " + p + " matches 0 files"));
                continue;
            }
            for (FileStatus globStat : matches) {
                if (globStat.isDir()) {
                    Collections.addAll(result, fs.listStatus(globStat.getPath(), (PathFilter)inputFilter));
                    continue;
                }
                result.add(globStat);
            }
        }
        if (!errors.isEmpty()) {
            throw new InvalidInputException(errors);
        }
        LOG.info((Object)("Total input paths to process : " + result.size()));
        return result;
    }

    protected List<FileStatus> listVertexStatus(JobContext job) throws IOException {
        return this.listStatus(job, GiraphFileInputFormat.getVertexInputPaths(job));
    }

    protected List<FileStatus> listEdgeStatus(JobContext job) throws IOException {
        return this.listStatus(job, GiraphFileInputFormat.getEdgeInputPaths(job));
    }

    private List<InputSplit> getSplits(JobContext job, List<FileStatus> files) throws IOException {
        long minSize = Math.max(this.getFormatMinSplitSize(), GiraphFileInputFormat.getMinSplitSize((JobContext)job));
        long maxSize = GiraphFileInputFormat.getMaxSplitSize((JobContext)job);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (FileStatus file : files) {
            Path path = file.getPath();
            FileSystem fs = path.getFileSystem(job.getConfiguration());
            long length = file.getLen();
            BlockLocation[] blkLocations = fs.getFileBlockLocations(file, 0L, length);
            if (length != 0L && this.isSplitable(job, path)) {
                long blockSize = file.getBlockSize();
                long splitSize = this.computeSplitSize(blockSize, minSize, maxSize);
                long bytesRemaining = length;
                while ((double)bytesRemaining / (double)splitSize > 1.1) {
                    int blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                    splits.add((InputSplit)new FileSplit(path, length - bytesRemaining, splitSize, blkLocations[blkIndex].getHosts()));
                    bytesRemaining -= splitSize;
                }
                if (bytesRemaining == 0L) continue;
                splits.add((InputSplit)new FileSplit(path, length - bytesRemaining, bytesRemaining, blkLocations[blkLocations.length - 1].getHosts()));
                continue;
            }
            if (length != 0L) {
                splits.add((InputSplit)new FileSplit(path, 0L, length, blkLocations[0].getHosts()));
                continue;
            }
            splits.add((InputSplit)new FileSplit(path, 0L, length, new String[0]));
        }
        return splits;
    }

    public List<InputSplit> getVertexSplits(JobContext job) throws IOException {
        List<FileStatus> files = this.listVertexStatus(job);
        List<InputSplit> splits = this.getSplits(job, files);
        job.getConfiguration().setLong(NUM_VERTEX_INPUT_FILES, (long)files.size());
        LOG.debug((Object)("Total # of vertex splits: " + splits.size()));
        return splits;
    }

    public List<InputSplit> getEdgeSplits(JobContext job) throws IOException {
        List<FileStatus> files = this.listEdgeStatus(job);
        List<InputSplit> splits = this.getSplits(job, files);
        job.getConfiguration().setLong(NUM_EDGE_INPUT_FILES, (long)files.size());
        LOG.debug((Object)("Total # of edge splits: " + splits.size()));
        return splits;
    }

    private static class MultiPathFilter
    implements PathFilter {
        private List<PathFilter> filters;

        public MultiPathFilter(List<PathFilter> filters) {
            this.filters = filters;
        }

        public boolean accept(Path path) {
            for (PathFilter filter : this.filters) {
                if (filter.accept(path)) continue;
                return false;
            }
            return true;
        }
    }
}

