/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.TextVertexOutputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AdjacencyListTextVertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends TextVertexOutputFormat<I, V, E> {
    public static final String LINE_TOKENIZE_VALUE = "output.delimiter";
    public static final String LINE_TOKENIZE_VALUE_DEFAULT = "\t";

    @Override
    public AdjacencyListTextVertexWriter createVertexWriter(TaskAttemptContext context) {
        return new AdjacencyListTextVertexWriter();
    }

    protected class AdjacencyListTextVertexWriter
    extends TextVertexOutputFormat.TextVertexWriterToEachLine {
        private String delimiter;

        protected AdjacencyListTextVertexWriter() {
            super(AdjacencyListTextVertexOutputFormat.this);
        }

        @Override
        public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
            super.initialize(context);
            this.delimiter = this.getConf().get(AdjacencyListTextVertexOutputFormat.LINE_TOKENIZE_VALUE, AdjacencyListTextVertexOutputFormat.LINE_TOKENIZE_VALUE_DEFAULT);
        }

        @Override
        public Text convertVertexToLine(Vertex<I, V, E> vertex) throws IOException {
            StringBuffer sb = new StringBuffer(vertex.getId().toString());
            sb.append(this.delimiter);
            sb.append(vertex.getValue());
            for (Edge edge : vertex.getEdges()) {
                sb.append(this.delimiter).append(edge.getTargetVertexId());
                sb.append(this.delimiter).append(edge.getValue());
            }
            return new Text(sb.toString());
        }
    }
}

