/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class AdjacencyListTextVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends TextVertexInputFormat<I, V, E> {
    public static final String LINE_TOKENIZE_VALUE = "adj.list.input.delimiter";
    public static final String LINE_TOKENIZE_VALUE_DEFAULT = "\t";

    @Override
    public abstract AdjacencyListTextVertexReader createVertexReader(InputSplit var1, TaskAttemptContext var2);

    protected abstract class AdjacencyListTextVertexReader
    extends TextVertexInputFormat.TextVertexReaderFromEachLineProcessed<String[]> {
        private String splitValue;
        private final LineSanitizer sanitizer;

        public AdjacencyListTextVertexReader() {
            this(null);
        }

        public AdjacencyListTextVertexReader(LineSanitizer sanitizer) {
            super(AdjacencyListTextVertexInputFormat.this);
            this.splitValue = null;
            this.sanitizer = sanitizer;
        }

        @Override
        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            super.initialize(inputSplit, context);
            this.splitValue = this.getConf().get(AdjacencyListTextVertexInputFormat.LINE_TOKENIZE_VALUE, AdjacencyListTextVertexInputFormat.LINE_TOKENIZE_VALUE_DEFAULT);
        }

        @Override
        protected String[] preprocessLine(Text line) throws IOException {
            String sanitizedLine = this.sanitizer != null ? this.sanitizer.sanitize(line.toString()) : line.toString();
            String[] values = sanitizedLine.split(this.splitValue);
            if (values.length < 2 || values.length % 2 != 0) {
                throw new IllegalArgumentException("Line did not split correctly: " + line);
            }
            return values;
        }

        @Override
        protected I getId(String[] values) throws IOException {
            return this.decodeId(values[0]);
        }

        public abstract I decodeId(String var1);

        @Override
        protected V getValue(String[] values) throws IOException {
            return this.decodeValue(values[1]);
        }

        public abstract V decodeValue(String var1);

        @Override
        protected Iterable<Edge<I, E>> getEdges(String[] values) throws IOException {
            LinkedList edges = Lists.newLinkedList();
            for (int i = 2; i < values.length; i += 2) {
                edges.add(this.decodeEdge(values[i], values[i + 1]));
            }
            return edges;
        }

        public abstract Edge<I, E> decodeEdge(String var1, String var2);
    }

    public static interface LineSanitizer {
        public String sanitize(String var1);
    }
}

