/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.io.EdgeReader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ReverseEdgeDuplicator<I extends WritableComparable, E extends Writable>
extends EdgeReader<I, E> {
    private final EdgeReader<I, E> baseReader;
    private boolean haveReverseEdge = true;
    private Edge<I, E> reverseEdge;
    private I reverseSourceId;

    public ReverseEdgeDuplicator(EdgeReader<I, E> baseReader) {
        this.baseReader = baseReader;
    }

    public EdgeReader<I, E> getBaseReader() {
        return this.baseReader;
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.baseReader.initialize(inputSplit, context);
        this.haveReverseEdge = true;
    }

    @Override
    public boolean nextEdge() throws IOException, InterruptedException {
        boolean result = true;
        if (this.haveReverseEdge) {
            result = this.baseReader.nextEdge();
            this.haveReverseEdge = false;
        } else {
            Edge<I, E> currentEdge = this.baseReader.getCurrentEdge();
            this.reverseSourceId = currentEdge.getTargetVertexId();
            this.reverseEdge = EdgeFactory.create(this.baseReader.getCurrentSourceId(), currentEdge.getValue());
            this.haveReverseEdge = true;
        }
        return result;
    }

    @Override
    public I getCurrentSourceId() throws IOException, InterruptedException {
        if (this.haveReverseEdge) {
            return this.reverseSourceId;
        }
        return this.baseReader.getCurrentSourceId();
    }

    @Override
    public Edge<I, E> getCurrentEdge() throws IOException, InterruptedException {
        if (this.haveReverseEdge) {
            return this.reverseEdge;
        }
        return this.baseReader.getCurrentEdge();
    }

    @Override
    public void close() throws IOException {
        this.baseReader.close();
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.baseReader.getProgress();
    }
}

