/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class GiraphInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends DefaultImmutableClassesGiraphConfigurable<I, V, E> {
    public abstract void checkInputSpecs(Configuration var1);

    public abstract List<InputSplit> getSplits(JobContext var1, int var2) throws IOException, InterruptedException;

    public void writeInputSplit(InputSplit inputSplit, DataOutput dataOutput) throws IOException {
        Text.writeString((DataOutput)dataOutput, (String)inputSplit.getClass().getName());
        ((Writable)inputSplit).write(dataOutput);
    }

    public InputSplit readInputSplit(DataInput dataInput) throws IOException, ClassNotFoundException {
        String inputSplitClass = Text.readString((DataInput)dataInput);
        InputSplit inputSplit = (InputSplit)ReflectionUtils.newInstance((Class)this.getConf().getClassByName(inputSplitClass), this.getConf());
        ((Writable)inputSplit).readFields(dataInput);
        return inputSplit;
    }
}

