/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.integration;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.BasicPartitionOwner;
import org.apache.giraph.partition.HashMasterPartitioner;
import org.apache.giraph.partition.HashPartitionerFactory;
import org.apache.giraph.partition.MasterGraphPartitioner;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.PartitionStats;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class SuperstepHashPartitionerFactory<I extends WritableComparable, V extends Writable, E extends Writable>
extends HashPartitionerFactory<I, V, E> {
    @Override
    public MasterGraphPartitioner<I, V, E> createMasterGraphPartitioner() {
        return new SuperstepMasterPartition(this.getConf());
    }

    private static class SuperstepMasterPartition<I extends WritableComparable, V extends Writable, E extends Writable>
    extends HashMasterPartitioner<I, V, E> {
        private static Logger LOG = Logger.getLogger(SuperstepMasterPartition.class);

        public SuperstepMasterPartition(ImmutableClassesGiraphConfiguration conf) {
            super(conf);
        }

        @Override
        public Collection<PartitionOwner> generateChangedPartitionOwners(Collection<PartitionStats> allPartitionStatsList, Collection<WorkerInfo> availableWorkerInfos, int maxWorkers, long superstep) {
            long workerIndex = superstep % (long)availableWorkerInfos.size();
            int i = 0;
            WorkerInfo chosenWorkerInfo = null;
            for (WorkerInfo workerInfo : availableWorkerInfos) {
                if (workerIndex == (long)i) {
                    chosenWorkerInfo = workerInfo;
                }
                ++i;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("generateChangedPartitionOwners: Chosen worker for superstep " + superstep + " is " + chosenWorkerInfo));
            }
            ArrayList<PartitionOwner> partitionOwnerList = new ArrayList<PartitionOwner>();
            for (PartitionOwner partitionOwner : this.getCurrentPartitionOwners()) {
                WorkerInfo prevWorkerinfo = partitionOwner.getWorkerInfo().equals(chosenWorkerInfo) ? null : partitionOwner.getWorkerInfo();
                BasicPartitionOwner tmpPartitionOwner = new BasicPartitionOwner(partitionOwner.getPartitionId(), chosenWorkerInfo, prevWorkerinfo, null);
                partitionOwnerList.add(tmpPartitionOwner);
                LOG.info((Object)("partition owner was " + partitionOwner + ", new " + tmpPartitionOwner));
            }
            this.setPartitionOwnerList(partitionOwnerList);
            return partitionOwnerList;
        }
    }
}

