/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexChanges;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.json.JSONException;
import org.json.JSONObject;

public class VertexMutations<I extends WritableComparable, V extends Writable, E extends Writable>
implements VertexChanges<I, V, E>,
Writable,
ImmutableClassesGiraphConfigurable {
    private final List<Vertex<I, V, E>> addedVertexList = Lists.newArrayList();
    private int removedVertexCount = 0;
    private final List<Edge<I, E>> addedEdgeList = Lists.newArrayList();
    private final List<I> removedEdgeList = Lists.newArrayList();
    private ImmutableClassesGiraphConfiguration<I, V, E> conf;

    public VertexMutations<I, V, E> copy() {
        VertexMutations<I, V, E> copied = new VertexMutations<I, V, E>();
        copied.addedVertexList.addAll(this.addedVertexList);
        copied.removedVertexCount = this.removedVertexCount;
        copied.addedEdgeList.addAll(this.addedEdgeList);
        copied.removedEdgeList.addAll(this.removedEdgeList);
        copied.conf = this.conf;
        return copied;
    }

    @Override
    public List<Vertex<I, V, E>> getAddedVertexList() {
        return this.addedVertexList;
    }

    public void readFields(DataInput input) throws IOException {
        this.addedVertexList.clear();
        this.addedEdgeList.clear();
        this.removedEdgeList.clear();
        int addedVertexListSize = input.readInt();
        for (int i = 0; i < addedVertexListSize; ++i) {
            Vertex vertex = WritableUtils.readVertexFromDataInput(input, this.getConf());
            this.addedVertexList.add(vertex);
        }
        this.removedVertexCount = input.readInt();
        int addedEdgeListSize = input.readInt();
        for (int i = 0; i < addedEdgeListSize; ++i) {
            Edge<I, E> edge = this.conf.createEdge();
            WritableUtils.readEdge(input, edge);
            this.addedEdgeList.add(edge);
        }
        int removedEdgeListSize = input.readInt();
        for (int i = 0; i < removedEdgeListSize; ++i) {
            I removedEdge = this.conf.createVertexId();
            removedEdge.readFields(input);
            this.removedEdgeList.add(removedEdge);
        }
    }

    public void write(DataOutput output) throws IOException {
        output.writeInt(this.addedVertexList.size());
        for (Vertex<I, V, E> vertex : this.addedVertexList) {
            WritableUtils.writeVertexToDataOutput(output, vertex, this.getConf());
        }
        output.writeInt(this.removedVertexCount);
        output.writeInt(this.addedEdgeList.size());
        for (Edge edge : this.addedEdgeList) {
            edge.getTargetVertexId().write(output);
            edge.getValue().write(output);
        }
        output.writeInt(this.removedEdgeList.size());
        for (WritableComparable writableComparable : this.removedEdgeList) {
            writableComparable.write(output);
        }
    }

    public void addVertex(Vertex<I, V, E> vertex) {
        this.addedVertexList.add(vertex);
    }

    @Override
    public int getRemovedVertexCount() {
        return this.removedVertexCount;
    }

    public void removeVertex() {
        ++this.removedVertexCount;
    }

    @Override
    public List<Edge<I, E>> getAddedEdgeList() {
        return this.addedEdgeList;
    }

    public void addEdge(Edge<I, E> edge) {
        this.addedEdgeList.add(edge);
    }

    @Override
    public List<I> getRemovedEdgeList() {
        return this.removedEdgeList;
    }

    public void removeEdge(I destinationVertexId) {
        this.removedEdgeList.add(destinationVertexId);
    }

    public void addVertexMutations(VertexMutations<I, V, E> vertexMutations) {
        this.addedVertexList.addAll(vertexMutations.getAddedVertexList());
        this.removedVertexCount += vertexMutations.getRemovedVertexCount();
        this.addedEdgeList.addAll(vertexMutations.getAddedEdgeList());
        this.removedEdgeList.addAll(vertexMutations.getRemovedEdgeList());
    }

    public String toString() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("added vertices", (Object)this.getAddedVertexList().toString());
            jsonObject.put("added edges", (Object)this.getAddedEdgeList().toString());
            jsonObject.put("removed vertex count", this.getRemovedVertexCount());
            jsonObject.put("removed edges", (Object)this.getRemovedEdgeList().toString());
            return jsonObject.toString();
        }
        catch (JSONException e) {
            throw new IllegalStateException("toString: Got a JSON exception", e);
        }
    }

    public ImmutableClassesGiraphConfiguration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration conf) {
        this.conf = conf;
    }
}

