/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.io.Writable;

public abstract class TaskInfo
implements Writable {
    private String hostname;
    private int port;
    private int taskId = -1;

    public String getHostname() {
        return this.hostname.toLowerCase();
    }

    public int getPort() {
        return this.port;
    }

    public void setInetSocketAddress(InetSocketAddress address) {
        this.port = address.getPort();
        this.hostname = address.getHostName();
    }

    public InetSocketAddress getInetSocketAddress() {
        return new InetSocketAddress(this.hostname, this.port);
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public String getHostnameId() {
        return this.getHostname() + "_" + this.getTaskId();
    }

    public boolean equals(Object other) {
        TaskInfo taskInfo;
        return other instanceof TaskInfo && this.hostname.equals((taskInfo = (TaskInfo)other).getHostname()) && this.getTaskId() == taskInfo.getTaskId() && this.port == taskInfo.getPort() && this.taskId == taskInfo.getTaskId();
    }

    public String toString() {
        return "hostname=" + this.getHostname() + ", MRtaskID=" + this.getTaskId() + ", port=" + this.getPort();
    }

    public void readFields(DataInput input) throws IOException {
        this.hostname = input.readUTF();
        this.port = input.readInt();
        this.taskId = input.readInt();
    }

    public void write(DataOutput output) throws IOException {
        output.writeUTF(this.hostname);
        output.writeInt(this.port);
        output.writeInt(this.taskId);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getPort();
        result = 37 * result + this.hostname.hashCode();
        result = 37 * result + this.getTaskId();
        return result;
    }
}

