/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import com.facebook.nifty.client.FramedClientConnector;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.swift.service.RuntimeTTransportException;
import com.facebook.swift.service.ThriftClientManager;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.graph.JobProgressTrackerClient;
import org.apache.giraph.job.JobProgressTracker;
import org.apache.giraph.worker.WorkerProgress;
import org.apache.log4j.Logger;

public class RetryableJobProgressTrackerClient
implements JobProgressTrackerClient {
    private static final Logger LOG = Logger.getLogger(RetryableJobProgressTrackerClient.class);
    private final GiraphConfiguration conf;
    private ThriftClientManager clientManager;
    private JobProgressTracker jobProgressTracker;

    public RetryableJobProgressTrackerClient(GiraphConfiguration conf) throws ExecutionException, InterruptedException {
        this.conf = conf;
        this.resetConnection();
    }

    private void resetConnection() throws ExecutionException, InterruptedException {
        this.clientManager = new ThriftClientManager();
        FramedClientConnector connector = new FramedClientConnector(new InetSocketAddress(JOB_PROGRESS_SERVICE_HOST.get(this.conf), JOB_PROGRESS_SERVICE_PORT.get(this.conf)));
        this.jobProgressTracker = (JobProgressTracker)this.clientManager.createClient((NiftyClientConnector)connector, JobProgressTracker.class).get();
    }

    @Override
    public synchronized void cleanup() throws IOException {
        block2: {
            Closeables.close((Closeable)this.clientManager, (boolean)true);
            try {
                this.clientManager.close();
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Exception occurred while trying to close JobProgressTracker", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void mapperStarted() {
        this.executeWithRetry(new Runnable(){

            @Override
            public void run() {
                RetryableJobProgressTrackerClient.this.jobProgressTracker.mapperStarted();
            }
        });
    }

    @Override
    public synchronized void logInfo(final String logLine) {
        this.executeWithRetry(new Runnable(){

            @Override
            public void run() {
                RetryableJobProgressTrackerClient.this.jobProgressTracker.logInfo(logLine);
            }
        });
    }

    @Override
    public synchronized void logFailure(final String reason) {
        this.executeWithRetry(new Runnable(){

            @Override
            public void run() {
                RetryableJobProgressTrackerClient.this.jobProgressTracker.logFailure(reason);
            }
        });
    }

    @Override
    public synchronized void updateProgress(final WorkerProgress workerProgress) {
        this.executeWithRetry(new Runnable(){

            @Override
            public void run() {
                RetryableJobProgressTrackerClient.this.jobProgressTracker.updateProgress(workerProgress);
            }
        });
    }

    private void executeWithRetry(Runnable runnable) {
        block10: {
            try {
                runnable.run();
            }
            catch (RuntimeTTransportException te) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"RuntimeTTransportException occurred while talking to JobProgressTracker server, trying to reconnect", (Throwable)te);
                }
                try {
                    block9: {
                        try {
                            this.clientManager.close();
                        }
                        catch (Exception e) {
                            if (!LOG.isDebugEnabled()) break block9;
                            LOG.debug((Object)"");
                        }
                    }
                    this.resetConnection();
                    runnable.run();
                }
                catch (Exception e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)"Exception occurred while talking to JobProgressTracker server, giving up", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) break block10;
                LOG.info((Object)"Exception occurred while talking to JobProgressTracker server, giving up", (Throwable)e);
            }
        }
    }
}

