/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import org.apache.giraph.conf.ClassConfOption;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.ValueFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;

public enum GraphType {
    VERTEX_ID{

        public ClassConfOption<? extends Writable> writableConfOption() {
            return GiraphConstants.VERTEX_ID_CLASS;
        }

        public ClassConfOption<? extends ValueFactory> factoryClassOption() {
            return GiraphConstants.VERTEX_ID_FACTORY_CLASS;
        }

        @Override
        public <T extends Writable> Class<T> get(ImmutableClassesGiraphConfiguration conf) {
            return conf.getVertexIdClass();
        }

        @Override
        public <T extends Writable> ValueFactory<T> factory(ImmutableClassesGiraphConfiguration conf) {
            return conf.getVertexIdFactory();
        }
    }
    ,
    VERTEX_VALUE{

        public ClassConfOption<? extends Writable> writableConfOption() {
            return GiraphConstants.VERTEX_VALUE_CLASS;
        }

        public ClassConfOption<? extends ValueFactory> factoryClassOption() {
            return GiraphConstants.VERTEX_VALUE_FACTORY_CLASS;
        }

        @Override
        public <T extends Writable> Class<T> get(ImmutableClassesGiraphConfiguration conf) {
            return conf.getVertexValueClass();
        }

        @Override
        public <T extends Writable> ValueFactory<T> factory(ImmutableClassesGiraphConfiguration conf) {
            return conf.getVertexValueFactory();
        }
    }
    ,
    EDGE_VALUE{

        public ClassConfOption<? extends Writable> writableConfOption() {
            return GiraphConstants.EDGE_VALUE_CLASS;
        }

        public ClassConfOption<? extends ValueFactory> factoryClassOption() {
            return GiraphConstants.EDGE_VALUE_FACTORY_CLASS;
        }

        @Override
        public <T extends Writable> Class<T> get(ImmutableClassesGiraphConfiguration conf) {
            return conf.getEdgeValueClass();
        }

        @Override
        public <T extends Writable> ValueFactory<T> factory(ImmutableClassesGiraphConfiguration conf) {
            return conf.getEdgeValueFactory();
        }
    }
    ,
    INCOMING_MESSAGE_VALUE{

        public ClassConfOption<? extends Writable> writableConfOption() {
            return GiraphConstants.INCOMING_MESSAGE_VALUE_CLASS;
        }

        public ClassConfOption<? extends ValueFactory> factoryClassOption() {
            return GiraphConstants.INCOMING_MESSAGE_VALUE_FACTORY_CLASS;
        }

        @Override
        public <T extends Writable> Class<T> get(ImmutableClassesGiraphConfiguration conf) {
            return conf.getIncomingMessageValueClass();
        }

        @Override
        public <T extends Writable> ValueFactory<T> factory(ImmutableClassesGiraphConfiguration conf) {
            return conf.getIncomingMessageValueFactory();
        }
    }
    ,
    OUTGOING_MESSAGE_VALUE{

        public ClassConfOption<? extends Writable> writableConfOption() {
            return GiraphConstants.OUTGOING_MESSAGE_VALUE_CLASS;
        }

        public ClassConfOption<? extends ValueFactory> factoryClassOption() {
            return GiraphConstants.OUTGOING_MESSAGE_VALUE_FACTORY_CLASS;
        }

        @Override
        public <T extends Writable> Class<T> get(ImmutableClassesGiraphConfiguration conf) {
            return conf.getOutgoingMessageValueClass();
        }

        @Override
        public <T extends Writable> ValueFactory<T> factory(ImmutableClassesGiraphConfiguration conf) {
            return conf.getOutgoingMessageValueFactory();
        }
    };


    public String toString() {
        return this.name().toLowerCase();
    }

    public String dotString() {
        return this.toString().replaceAll("_", ".");
    }

    public String spaceString() {
        return this.toString().replaceAll("_", " ");
    }

    public abstract <T extends Writable> Class<T> get(ImmutableClassesGiraphConfiguration var1);

    public abstract <T extends Writable> ValueFactory<T> factory(ImmutableClassesGiraphConfiguration var1);

    public abstract <T extends ValueFactory> ClassConfOption<T> factoryClassOption();

    public abstract <T extends Writable> ClassConfOption<T> writableConfOption();

    public <T extends Writable> Class<T> interfaceClass() {
        return this.writableConfOption().getInterfaceClass();
    }

    public <T extends Writable> Class<? extends T> get(Configuration conf) {
        if (conf instanceof ImmutableClassesGiraphConfiguration) {
            ImmutableClassesGiraphConfiguration icgc = (ImmutableClassesGiraphConfiguration)conf;
            return this.get(icgc);
        }
        return this.writableConfOption().get(conf);
    }

    public <T extends Writable> T newInstance(ImmutableClassesGiraphConfiguration conf) {
        return this.factory(conf).newInstance();
    }
}

