/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.giraph.bsp.CentralizedServiceMaster;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.bsp.CheckpointStatus;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.ComputeCallable;
import org.apache.giraph.graph.FinishedSuperstepStats;
import org.apache.giraph.graph.GlobalStats;
import org.apache.giraph.graph.GraphFunctions;
import org.apache.giraph.graph.GraphState;
import org.apache.giraph.graph.JobProgressTrackerClient;
import org.apache.giraph.graph.JobProgressTrackerClientNoOp;
import org.apache.giraph.graph.RetryableJobProgressTrackerClient;
import org.apache.giraph.graph.VertexEdgeCount;
import org.apache.giraph.job.JobProgressTracker;
import org.apache.giraph.master.BspServiceMaster;
import org.apache.giraph.master.MasterThread;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.metrics.GiraphMetricsRegistry;
import org.apache.giraph.metrics.GiraphTimer;
import org.apache.giraph.metrics.GiraphTimerContext;
import org.apache.giraph.metrics.ResetSuperstepMetricsObserver;
import org.apache.giraph.metrics.SuperstepMetricsRegistry;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.PartitionStats;
import org.apache.giraph.partition.PartitionStore;
import org.apache.giraph.scripting.ScriptLoader;
import org.apache.giraph.utils.CallableFactory;
import org.apache.giraph.utils.MemoryUtils;
import org.apache.giraph.utils.ProgressableUtils;
import org.apache.giraph.worker.BspServiceWorker;
import org.apache.giraph.worker.InputSplitsCallable;
import org.apache.giraph.worker.WorkerContext;
import org.apache.giraph.worker.WorkerObserver;
import org.apache.giraph.worker.WorkerProgress;
import org.apache.giraph.zk.ZooKeeperManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.zookeeper.server.PrepRequestProcessor;

public class GraphTaskManager<I extends WritableComparable, V extends Writable, E extends Writable>
implements ResetSuperstepMetricsObserver {
    public static final String TIMER_SUPERSTEP_TIME = "superstep-time-ms";
    public static final String TIMER_COMPUTE_ALL = "compute-all-ms";
    public static final String TIMER_TIME_TO_FIRST_MSG = "time-to-first-message-ms";
    public static final String TIMER_COMMUNICATION_TIME = "communication-time-ms";
    private static final Logger LOG = Logger.getLogger(GraphTaskManager.class);
    private CentralizedServiceWorker<I, V, E> serviceWorker;
    private CentralizedServiceMaster<I, V, E> serviceMaster;
    private Thread masterThread = null;
    private boolean alreadyRun = false;
    private ZooKeeperManager zkManager;
    private ImmutableClassesGiraphConfiguration<I, V, E> conf;
    private boolean done = false;
    private GraphFunctions graphFunctions = GraphFunctions.UNKNOWN;
    private FinishedSuperstepStats finishedSuperstepStats = new FinishedSuperstepStats(0L, false, 0L, 0L, false, CheckpointStatus.NONE);
    private JobProgressTrackerClient jobProgressTracker;
    private GiraphTimer wcPreAppTimer;
    private GiraphTimer wcPostAppTimer;
    private GiraphTimer superstepTimer;
    private GiraphTimer computeAll;
    private GiraphTimer timeToFirstMessage;
    private GiraphTimerContext timeToFirstMessageTimerContext;
    private GiraphTimer communicationTimer;
    private GiraphTimerContext communicationTimerContext;
    private GiraphTimer wcPreSuperstepTimer;
    private final Mapper.Context context;
    private boolean isMaster;

    public GraphTaskManager(Mapper.Context context) {
        this.context = context;
        this.isMaster = false;
    }

    private void checkInput() {
        if (this.conf.hasEdgeInputFormat()) {
            this.conf.createWrappedEdgeInputFormat().checkInputSpecs(this.conf);
        }
        if (this.conf.hasVertexInputFormat()) {
            this.conf.createWrappedVertexInputFormat().checkInputSpecs(this.conf);
        }
    }

    private void createZooKeeperCounter(String serverPortList) {
        this.context.getCounter("Zookeeper server:port", serverPortList);
    }

    public void setup(Path[] zkPathList) throws IOException, InterruptedException {
        this.context.setStatus("setup: Beginning worker setup.");
        Configuration hadoopConf = this.context.getConfiguration();
        this.conf = new ImmutableClassesGiraphConfiguration(hadoopConf);
        this.initializeJobProgressTracker();
        this.conf.getGiraphTypes().writeIfUnset(this.conf);
        this.initializeAndConfigureLogging();
        this.setupAndInitializeGiraphMetrics();
        this.checkInput();
        ScriptLoader.loadScripts(this.conf);
        this.conf.createComputationFactory().initialize(this.conf);
        this.context.setStatus("setup: Initializing Zookeeper services.");
        String serverPortList = this.conf.getZookeeperList();
        if (serverPortList.isEmpty()) {
            if (this.startZooKeeperManager()) {
                return;
            }
        } else {
            this.createZooKeeperCounter(serverPortList);
        }
        if (this.zkManager != null && this.zkManager.runsZooKeeper() && LOG.isInfoEnabled()) {
            LOG.info((Object)"setup: Chosen to run ZooKeeper...");
        }
        this.context.setStatus("setup: Connected to Zookeeper service " + serverPortList);
        this.graphFunctions = GraphTaskManager.determineGraphFunctions(this.conf, this.zkManager);
        if (this.conf.getZooKeeperServerCount() > 1) {
            Thread.sleep(60000L);
        }
        try {
            this.instantiateBspService();
        }
        catch (IOException e) {
            LOG.error((Object)"setup: Caught exception just before end of setup", (Throwable)e);
            if (this.zkManager != null) {
                this.zkManager.offlineZooKeeperServers(ZooKeeperManager.State.FAILED);
            }
            throw new RuntimeException("setup: Offlining servers due to exception...", e);
        }
        this.context.setStatus(this.getGraphFunctions().toString() + " starting...");
    }

    private void initializeJobProgressTracker() {
        if (!this.conf.trackJobProgressOnClient()) {
            this.jobProgressTracker = new JobProgressTrackerClientNoOp();
        } else {
            try {
                this.jobProgressTracker = new RetryableJobProgressTrackerClient(this.conf);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn((Object)"createJobProgressClient: Exception occurred while trying to connect to JobProgressTracker - not reporting progress", (Throwable)e);
                this.jobProgressTracker = new JobProgressTrackerClientNoOp();
            }
        }
        this.jobProgressTracker.mapperStarted();
    }

    public void execute() throws IOException, InterruptedException {
        if (this.checkTaskState()) {
            return;
        }
        this.preLoadOnWorkerObservers();
        this.finishedSuperstepStats = this.serviceWorker.setup();
        if (this.collectInputSuperstepStats(this.finishedSuperstepStats)) {
            return;
        }
        this.prepareGraphStateAndWorkerContext();
        ArrayList<PartitionStats> partitionStatsList = new ArrayList<PartitionStats>();
        int numComputeThreads = this.conf.getNumComputeThreads();
        while (!this.finishedSuperstepStats.allVerticesHalted()) {
            long superstep = this.serviceWorker.getSuperstep();
            GiraphTimerContext superstepTimerContext = this.getTimerForThisSuperstep(superstep);
            GraphState graphState = new GraphState(superstep, this.finishedSuperstepStats.getVertexCount(), this.finishedSuperstepStats.getEdgeCount(), this.context);
            Collection<PartitionOwner> masterAssignedPartitionOwners = this.serviceWorker.startSuperstep();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("execute: " + MemoryUtils.getRuntimeMemoryStats()));
            }
            this.context.progress();
            this.serviceWorker.exchangeVertexPartitions(masterAssignedPartitionOwners);
            this.context.progress();
            boolean hasBeenRestarted = this.checkSuperstepRestarted(superstep);
            GlobalStats globalStats = this.serviceWorker.getGlobalStats();
            if (hasBeenRestarted) {
                graphState = new GraphState(superstep, this.finishedSuperstepStats.getVertexCount(), this.finishedSuperstepStats.getEdgeCount(), this.context);
            } else if (this.storeCheckpoint(globalStats.getCheckpointStatus())) break;
            this.prepareForSuperstep(graphState);
            this.context.progress();
            MessageStore messageStore = this.serviceWorker.getServerData().getCurrentMessageStore();
            int numPartitions = this.serviceWorker.getPartitionStore().getNumPartitions();
            int numThreads = Math.min(numComputeThreads, numPartitions);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("execute: " + numPartitions + " partitions to process with " + numThreads + " compute thread(s), originally " + numComputeThreads + " thread(s) on superstep " + superstep));
            }
            partitionStatsList.clear();
            if (numPartitions > 0) {
                this.processGraphPartitions(this.context, partitionStatsList, graphState, messageStore, numPartitions, numThreads);
            }
            this.finishedSuperstepStats = this.completeSuperstepAndCollectStats(partitionStatsList, superstepTimerContext);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"execute: BSP application done (global vertices marked done)");
        }
        this.updateSuperstepGraphState();
        this.postApplication();
    }

    private void postApplication() throws IOException, InterruptedException {
        GiraphTimerContext postAppTimerContext = this.wcPostAppTimer.time();
        this.serviceWorker.getWorkerContext().postApplication();
        this.serviceWorker.getSuperstepOutput().postApplication();
        postAppTimerContext.stop();
        this.context.progress();
        for (WorkerObserver obs : this.serviceWorker.getWorkerObservers()) {
            obs.postApplication();
            this.context.progress();
        }
    }

    public void setIsMaster(boolean im) {
        this.isMaster = im;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    private GiraphTimerContext getTimerForThisSuperstep(long superstep) {
        GiraphMetrics.get().resetSuperstepMetrics(superstep);
        return this.superstepTimer.time();
    }

    private void setupAndInitializeGiraphMetrics() {
        GiraphMetrics.init(this.conf);
        GiraphMetrics.get().addSuperstepResetObserver(this);
        this.initJobMetrics();
        MemoryUtils.initMetrics();
        InputSplitsCallable.initMetrics();
    }

    private boolean startZooKeeperManager() throws IOException, InterruptedException {
        this.zkManager = new ZooKeeperManager(this.context, this.conf);
        this.context.setStatus("setup: Setting up Zookeeper manager.");
        this.zkManager.setup();
        if (this.zkManager.computationDone()) {
            this.done = true;
            return true;
        }
        this.zkManager.onlineZooKeeperServers();
        String serverPortList = this.zkManager.getZooKeeperServerPortString();
        this.conf.setZookeeperList(serverPortList);
        this.createZooKeeperCounter(serverPortList);
        return false;
    }

    private void updateSuperstepGraphState() {
        this.serviceWorker.getWorkerContext().setGraphState(new GraphState(this.serviceWorker.getSuperstep(), this.finishedSuperstepStats.getVertexCount(), this.finishedSuperstepStats.getEdgeCount(), this.context));
    }

    private FinishedSuperstepStats completeSuperstepAndCollectStats(List<PartitionStats> partitionStatsList, GiraphTimerContext superstepTimerContext) {
        this.finishedSuperstepStats = this.serviceWorker.finishSuperstep(partitionStatsList, superstepTimerContext);
        if (this.conf.metricsEnabled()) {
            GiraphMetrics.get().perSuperstep().printSummary(System.err);
        }
        return this.finishedSuperstepStats;
    }

    private void prepareForSuperstep(GraphState graphState) {
        this.serviceWorker.prepareSuperstep();
        this.serviceWorker.getWorkerContext().setGraphState(graphState);
        this.serviceWorker.getWorkerContext().setupSuperstep(this.serviceWorker);
        GiraphTimerContext preSuperstepTimer = this.wcPreSuperstepTimer.time();
        this.serviceWorker.getWorkerContext().preSuperstep();
        preSuperstepTimer.stop();
        this.context.progress();
        for (WorkerObserver obs : this.serviceWorker.getWorkerObservers()) {
            obs.preSuperstep(graphState.getSuperstep());
            this.context.progress();
        }
    }

    private void prepareGraphStateAndWorkerContext() {
        this.updateSuperstepGraphState();
        this.workerContextPreApp();
    }

    public GraphFunctions getGraphFunctions() {
        return this.graphFunctions;
    }

    public final WorkerContext getWorkerContext() {
        return this.serviceWorker.getWorkerContext();
    }

    public JobProgressTracker getJobProgressTracker() {
        return this.jobProgressTracker;
    }

    private static String findContainingJar(Class<?> myClass) {
        ClassLoader loader = myClass.getClassLoader();
        String classFile = myClass.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(classFile);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static GraphFunctions determineGraphFunctions(ImmutableClassesGiraphConfiguration conf, ZooKeeperManager zkManager) {
        int masterCount;
        boolean splitMasterWorker = conf.getSplitMasterWorker();
        int taskPartition = conf.getTaskPartition();
        boolean zkAlreadyProvided = conf.isZookeeperExternal();
        GraphFunctions functions = GraphFunctions.UNKNOWN;
        functions = !splitMasterWorker ? (zkManager != null && zkManager.runsZooKeeper() ? GraphFunctions.ALL : GraphFunctions.ALL_EXCEPT_ZOOKEEPER) : (zkAlreadyProvided ? (taskPartition < (masterCount = conf.getZooKeeperServerCount()) ? GraphFunctions.MASTER_ONLY : GraphFunctions.WORKER_ONLY) : (zkManager != null && zkManager.runsZooKeeper() ? GraphFunctions.MASTER_ZOOKEEPER_ONLY : GraphFunctions.WORKER_ONLY));
        return functions;
    }

    private void instantiateBspService() throws IOException, InterruptedException {
        if (this.graphFunctions.isMaster()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"setup: Starting up BspServiceMaster (master thread)...");
            }
            this.serviceMaster = new BspServiceMaster(this.context, this);
            this.masterThread = new MasterThread<I, V, E>(this.serviceMaster, this.context);
            this.masterThread.start();
        }
        if (this.graphFunctions.isWorker()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"setup: Starting up BspServiceWorker...");
            }
            this.serviceWorker = new BspServiceWorker(this.context, this);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"setup: Registering health of this worker...");
            }
        }
    }

    private void initializeAndConfigureLogging() {
        String logLevel = this.conf.getLocalLevel();
        if (!Logger.getRootLogger().getLevel().equals((Object)Level.toLevel((String)logLevel))) {
            Logger.getRootLogger().setLevel(Level.toLevel((String)logLevel));
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("setup: Set log level to " + logLevel));
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)("setup: Log level remains at " + logLevel));
        }
        if (this.conf.useLogThreadLayout()) {
            PatternLayout layout = new PatternLayout("%-7p %d [%t] %c %x - %m%n");
            Enumeration appenderEnum = Logger.getRootLogger().getAllAppenders();
            while (appenderEnum.hasMoreElements()) {
                ((Appender)appenderEnum.nextElement()).setLayout((Layout)layout);
            }
        }
        if (this.conf.getLocalTestMode()) {
            LogManager.getLogger((String)PrepRequestProcessor.class.getName()).setLevel(Level.ERROR);
        }
    }

    private void initJobMetrics() {
        GiraphMetricsRegistry jobMetrics = GiraphMetrics.get().perJobOptional();
        this.wcPreAppTimer = new GiraphTimer(jobMetrics, "worker-context-pre-app", TimeUnit.MILLISECONDS);
        this.wcPostAppTimer = new GiraphTimer(jobMetrics, "worker-context-post-app", TimeUnit.MILLISECONDS);
    }

    @Override
    public void newSuperstep(SuperstepMetricsRegistry superstepMetrics) {
        this.superstepTimer = new GiraphTimer(superstepMetrics, TIMER_SUPERSTEP_TIME, TimeUnit.MILLISECONDS);
        this.computeAll = new GiraphTimer(superstepMetrics, TIMER_COMPUTE_ALL, TimeUnit.MILLISECONDS);
        this.timeToFirstMessage = new GiraphTimer(superstepMetrics, TIMER_TIME_TO_FIRST_MSG, TimeUnit.MICROSECONDS);
        this.communicationTimer = new GiraphTimer(superstepMetrics, TIMER_COMMUNICATION_TIME, TimeUnit.MILLISECONDS);
        this.wcPreSuperstepTimer = new GiraphTimer(superstepMetrics, "worker-context-pre-superstep", TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySentMessages() {
        GiraphTimerContext tmp = this.timeToFirstMessageTimerContext;
        if (tmp != null) {
            GiraphTimer giraphTimer = this.timeToFirstMessage;
            synchronized (giraphTimer) {
                if (this.timeToFirstMessageTimerContext != null) {
                    this.timeToFirstMessageTimerContext.stop();
                    this.timeToFirstMessageTimerContext = null;
                    this.communicationTimerContext = this.communicationTimer.time();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFinishedCommunication() {
        GiraphTimerContext tmp = this.communicationTimerContext;
        if (tmp != null) {
            GiraphTimer giraphTimer = this.communicationTimer;
            synchronized (giraphTimer) {
                if (this.communicationTimerContext != null) {
                    this.communicationTimerContext.stop();
                    this.communicationTimerContext = null;
                }
            }
        }
    }

    private void processGraphPartitions(final Mapper.Context context, List<PartitionStats> partitionStatsList, final GraphState graphState, final MessageStore<I, Writable> messageStore, int numPartitions, int numThreads) {
        final ArrayBlockingQueue<Integer> computePartitionIdQueue = new ArrayBlockingQueue<Integer>(numPartitions);
        long verticesToCompute = 0L;
        PartitionStore<I, V, E> partitionStore = this.serviceWorker.getPartitionStore();
        for (Integer partitionId : partitionStore.getPartitionIds()) {
            computePartitionIdQueue.add(partitionId);
            Partition<I, V, E> partition = partitionStore.getOrCreatePartition(partitionId);
            verticesToCompute += partition.getVertexCount();
            partitionStore.putPartition(partition);
        }
        WorkerProgress.get().startSuperstep(this.serviceWorker.getSuperstep(), verticesToCompute, this.serviceWorker.getPartitionStore().getNumPartitions());
        GiraphTimerContext computeAllTimerContext = this.computeAll.time();
        this.timeToFirstMessageTimerContext = this.timeToFirstMessage.time();
        CallableFactory<Collection<PartitionStats>> callableFactory = new CallableFactory<Collection<PartitionStats>>(){

            @Override
            public Callable<Collection<PartitionStats>> newCallable(int callableId) {
                return new ComputeCallable(context, graphState, messageStore, computePartitionIdQueue, GraphTaskManager.this.conf, GraphTaskManager.this.serviceWorker);
            }
        };
        List<Collection<PartitionStats>> results = ProgressableUtils.getResultsWithNCallables(callableFactory, numThreads, "compute-%d", (Progressable)context);
        for (Collection<PartitionStats> result : results) {
            partitionStatsList.addAll(result);
        }
        computeAllTimerContext.stop();
    }

    private boolean checkSuperstepRestarted(long superstep) throws IOException {
        if (this.serviceWorker.getRestartedSuperstep() == superstep) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("execute: Loading from checkpoint " + superstep));
            }
            VertexEdgeCount vertexEdgeCount = this.serviceWorker.loadCheckpoint(this.serviceWorker.getRestartedSuperstep());
            this.finishedSuperstepStats = new FinishedSuperstepStats(0L, false, vertexEdgeCount.getVertexCount(), vertexEdgeCount.getEdgeCount(), false, CheckpointStatus.NONE);
            return true;
        }
        return false;
    }

    private boolean storeCheckpoint(CheckpointStatus checkpointStatus) throws IOException {
        if (checkpointStatus != CheckpointStatus.NONE) {
            this.serviceWorker.storeCheckpoint();
        }
        return checkpointStatus == CheckpointStatus.CHECKPOINT_AND_HALT;
    }

    private boolean collectInputSuperstepStats(FinishedSuperstepStats inputSuperstepStats) {
        if (inputSuperstepStats.getVertexCount() == 0L && !inputSuperstepStats.mustLoadCheckpoint()) {
            LOG.warn((Object)"map: No vertices in the graph, exiting.");
            return true;
        }
        if (this.conf.metricsEnabled()) {
            GiraphMetrics.get().perSuperstep().printSummary(System.err);
        }
        return false;
    }

    private boolean checkTaskState() {
        if (this.done) {
            return true;
        }
        GiraphMetrics.get().resetSuperstepMetrics(-1L);
        if (this.graphFunctions.isNotAWorker()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"map: No need to do anything when not a worker");
            }
            return true;
        }
        if (this.alreadyRun) {
            throw new RuntimeException("map: In BSP, map should have only been run exactly once, (already run)");
        }
        this.alreadyRun = true;
        return false;
    }

    private void workerContextPreApp() {
        GiraphTimerContext preAppTimerContext = this.wcPreAppTimer.time();
        try {
            this.serviceWorker.getWorkerContext().preApplication();
        }
        catch (InstantiationException e) {
            LOG.fatal((Object)"execute: preApplication failed in instantiation", (Throwable)e);
            throw new RuntimeException("execute: preApplication failed in instantiation", e);
        }
        catch (IllegalAccessException e) {
            LOG.fatal((Object)"execute: preApplication failed in access", (Throwable)e);
            throw new RuntimeException("execute: preApplication failed in access", e);
        }
        preAppTimerContext.stop();
        this.context.progress();
        for (WorkerObserver obs : this.serviceWorker.getWorkerObservers()) {
            obs.preApplication();
            this.context.progress();
        }
    }

    private void preLoadOnWorkerObservers() {
        for (WorkerObserver obs : this.serviceWorker.getWorkerObservers()) {
            obs.preLoad();
            this.context.progress();
        }
    }

    private void postSaveOnWorkerObservers() {
        for (WorkerObserver obs : this.serviceWorker.getWorkerObservers()) {
            obs.postSave();
            this.context.progress();
        }
    }

    public void cleanup() throws IOException, InterruptedException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("cleanup: Starting for " + (Object)((Object)this.getGraphFunctions())));
        }
        this.jobProgressTracker.cleanup();
        if (this.done) {
            return;
        }
        if (this.serviceWorker != null) {
            this.serviceWorker.cleanup(this.finishedSuperstepStats);
            this.postSaveOnWorkerObservers();
        }
        try {
            if (this.masterThread != null) {
                this.masterThread.join();
                LOG.info((Object)"cleanup: Joined with master thread");
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)"cleanup: Master thread couldn't join");
        }
        if (this.zkManager != null) {
            LOG.info((Object)"cleanup: Offlining ZooKeeper servers");
            try {
                this.zkManager.offlineZooKeeperServers(ZooKeeperManager.State.FINISHED);
            }
            catch (Throwable e) {
                LOG.error((Object)"cleanup: Error offlining zookeeper", e);
            }
        }
        GiraphMetrics.get().shutdown();
    }

    public void zooKeeperCleanup() {
        if (this.graphFunctions.isZooKeeper() && this.zkManager != null) {
            this.zkManager.logZooKeeperOutput(Level.WARN);
        }
    }

    public void workerFailureCleanup() {
        try {
            if (this.graphFunctions.isWorker()) {
                this.serviceWorker.failureCleanup();
            }
            GiraphMetrics.get().shutdown();
        }
        catch (RuntimeException e1) {
            LOG.error((Object)"run: Worker failure failed on another RuntimeException, original expection will be rethrown", (Throwable)e1);
        }
    }

    public Thread.UncaughtExceptionHandler createUncaughtExceptionHandler() {
        return new OverrideExceptionHandler();
    }

    public ImmutableClassesGiraphConfiguration<I, V, E> getConf() {
        return this.conf;
    }

    class OverrideExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        OverrideExceptionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            try {
                LOG.fatal((Object)("uncaughtException: OverrideExceptionHandler on thread " + t.getName() + ", msg = " + e.getMessage() + ", exiting..."), e);
                GraphTaskManager.this.zooKeeperCleanup();
                GraphTaskManager.this.workerFailureCleanup();
            }
            finally {
                System.exit(1);
            }
        }
    }
}

