/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import java.io.IOException;
import org.apache.giraph.graph.GraphTaskManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;

public class GraphMapper<I extends WritableComparable, V extends Writable, E extends Writable>
extends Mapper<Object, Object, Object, Object> {
    private static final Logger LOG = Logger.getLogger(GraphMapper.class);
    private GraphTaskManager<I, V, E> graphTaskManager;

    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.graphTaskManager = new GraphTaskManager(context);
        Thread.setDefaultUncaughtExceptionHandler(this.graphTaskManager.createUncaughtExceptionHandler());
        this.graphTaskManager.setup(DistributedCache.getLocalCacheArchives((Configuration)context.getConfiguration()));
    }

    public void map(Object key, Object value, Mapper.Context context) throws IOException, InterruptedException {
    }

    public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        this.graphTaskManager.cleanup();
    }

    public void run(Mapper.Context context) throws IOException, InterruptedException {
        try {
            this.setup(context);
            while (context.nextKeyValue()) {
                this.graphTaskManager.execute();
            }
            this.cleanup(context);
        }
        catch (RuntimeException e) {
            LOG.error((Object)("Caught an unrecoverable exception " + e.getMessage()), (Throwable)e);
            this.graphTaskManager.zooKeeperCleanup();
            this.graphTaskManager.workerFailureCleanup();
            throw new IllegalStateException("run: Caught an unrecoverable exception " + e.getMessage(), e);
        }
    }
}

