/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

public enum GraphFunctions {
    UNKNOWN{

        @Override
        public boolean isMaster() {
            return false;
        }

        @Override
        public boolean isWorker() {
            return false;
        }

        @Override
        public boolean isZooKeeper() {
            return false;
        }
    }
    ,
    MASTER_ONLY{

        @Override
        public boolean isMaster() {
            return true;
        }

        @Override
        public boolean isWorker() {
            return false;
        }

        @Override
        public boolean isZooKeeper() {
            return false;
        }
    }
    ,
    MASTER_ZOOKEEPER_ONLY{

        @Override
        public boolean isMaster() {
            return true;
        }

        @Override
        public boolean isWorker() {
            return false;
        }

        @Override
        public boolean isZooKeeper() {
            return true;
        }
    }
    ,
    WORKER_ONLY{

        @Override
        public boolean isMaster() {
            return false;
        }

        @Override
        public boolean isWorker() {
            return true;
        }

        @Override
        public boolean isZooKeeper() {
            return false;
        }
    }
    ,
    ALL{

        @Override
        public boolean isMaster() {
            return true;
        }

        @Override
        public boolean isWorker() {
            return true;
        }

        @Override
        public boolean isZooKeeper() {
            return true;
        }
    }
    ,
    ALL_EXCEPT_ZOOKEEPER{

        @Override
        public boolean isMaster() {
            return true;
        }

        @Override
        public boolean isWorker() {
            return true;
        }

        @Override
        public boolean isZooKeeper() {
            return false;
        }
    };


    public abstract boolean isMaster();

    public abstract boolean isWorker();

    public abstract boolean isZooKeeper();

    public boolean isKnown() {
        return this != UNKNOWN;
    }

    public boolean isUnknown() {
        return !this.isKnown();
    }

    public boolean isNotAWorker() {
        return this.isKnown() && !this.isWorker();
    }
}

