/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.bsp.CheckpointStatus;
import org.apache.giraph.partition.PartitionStats;
import org.apache.hadoop.io.Writable;

public class GlobalStats
implements Writable {
    private long vertexCount = 0L;
    private long finishedVertexCount = 0L;
    private long edgeCount = 0L;
    private long messageCount = 0L;
    private long messageBytesCount = 0L;
    private boolean haltComputation = false;
    private CheckpointStatus checkpointStatus = CheckpointStatus.NONE;

    public void addPartitionStats(PartitionStats partitionStats) {
        this.vertexCount += partitionStats.getVertexCount();
        this.finishedVertexCount += partitionStats.getFinishedVertexCount();
        this.edgeCount += partitionStats.getEdgeCount();
    }

    public long getVertexCount() {
        return this.vertexCount;
    }

    public long getFinishedVertexCount() {
        return this.finishedVertexCount;
    }

    public long getEdgeCount() {
        return this.edgeCount;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public long getMessageBytesCount() {
        return this.messageBytesCount;
    }

    public boolean getHaltComputation() {
        return this.haltComputation;
    }

    public void setHaltComputation(boolean value) {
        this.haltComputation = value;
    }

    public CheckpointStatus getCheckpointStatus() {
        return this.checkpointStatus;
    }

    public void setCheckpointStatus(CheckpointStatus checkpointStatus) {
        this.checkpointStatus = checkpointStatus;
    }

    public void addMessageCount(long messageCount) {
        this.messageCount += messageCount;
    }

    public void addMessageBytesCount(long msgBytesCount) {
        this.messageBytesCount += msgBytesCount;
    }

    public void readFields(DataInput input) throws IOException {
        this.vertexCount = input.readLong();
        this.finishedVertexCount = input.readLong();
        this.edgeCount = input.readLong();
        this.messageCount = input.readLong();
        this.messageBytesCount = input.readLong();
        this.haltComputation = input.readBoolean();
        this.checkpointStatus = input.readBoolean() ? CheckpointStatus.values()[input.readInt()] : null;
    }

    public void write(DataOutput output) throws IOException {
        output.writeLong(this.vertexCount);
        output.writeLong(this.finishedVertexCount);
        output.writeLong(this.edgeCount);
        output.writeLong(this.messageCount);
        output.writeLong(this.messageBytesCount);
        output.writeBoolean(this.haltComputation);
        output.writeBoolean(this.checkpointStatus != null);
        if (this.checkpointStatus != null) {
            output.writeInt(this.checkpointStatus.ordinal());
        }
    }

    public String toString() {
        return "(vtx=" + this.vertexCount + ",finVtx=" + this.finishedVertexCount + ",edges=" + this.edgeCount + ",msgCount=" + this.messageCount + ",msgBytesCount=" + this.messageBytesCount + ",haltComputation=" + this.haltComputation + ", checkpointStatus=" + (Object)((Object)this.checkpointStatus) + ')';
    }
}

