/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class GiraphTransferRegulator {
    public static final String MAX_VERTICES_PER_TRANSFER = "giraph.maxVerticesPerTransfer";
    public static final int MAX_VERTICES_PER_TRANSFER_DEFAULT = 10000;
    public static final String MAX_EDGES_PER_TRANSFER = "giraph.maxEdgesPerTransfer";
    public static final int MAX_EDGES_PER_TRANSFER_DEFAULT = 80000;
    private Map<Integer, Integer> edgeAccumulator;
    private Map<Integer, Integer> vertexAccumulator = Maps.newHashMap();
    private final int maxVerticesPerTransfer;
    private final int maxEdgesPerTransfer;
    private long totalVertexCount;
    private long totalEdgeCount;

    public GiraphTransferRegulator(Configuration conf) {
        this.edgeAccumulator = Maps.newHashMap();
        this.maxVerticesPerTransfer = conf.getInt(MAX_VERTICES_PER_TRANSFER, 10000);
        this.maxEdgesPerTransfer = conf.getInt(MAX_EDGES_PER_TRANSFER, 80000);
        this.totalEdgeCount = 0L;
        this.totalVertexCount = 0L;
    }

    public boolean transferThisPartition(PartitionOwner owner) {
        int partitionId = owner.getPartitionId();
        if (this.getEdgesForPartition(partitionId) >= this.maxEdgesPerTransfer || this.getVerticesForPartition(partitionId) >= this.maxVerticesPerTransfer) {
            this.vertexAccumulator.put(partitionId, 0);
            this.edgeAccumulator.put(partitionId, 0);
            return true;
        }
        return false;
    }

    private int getVerticesForPartition(int partId) {
        return this.vertexAccumulator.get(partId) == null ? 0 : this.vertexAccumulator.get(partId);
    }

    private int getEdgesForPartition(int partId) {
        return this.edgeAccumulator.get(partId) == null ? 0 : this.edgeAccumulator.get(partId);
    }

    public void clearCounters() {
        this.totalEdgeCount = 0L;
        this.totalVertexCount = 0L;
        this.vertexAccumulator.clear();
        this.edgeAccumulator.clear();
    }

    public <I extends WritableComparable, V extends Writable, E extends Writable> void incrementCounters(PartitionOwner partitionOwner, Vertex<I, V, E> vertex) {
        int id = partitionOwner.getPartitionId();
        this.vertexAccumulator.put(id, this.getVerticesForPartition(id) + 1);
        ++this.totalVertexCount;
        this.totalEdgeCount += (long)vertex.getNumEdges();
        this.edgeAccumulator.put(id, this.getEdgesForPartition(id) + vertex.getNumEdges());
    }

    public long getMaxEdgesPerTransfer() {
        return this.maxEdgesPerTransfer;
    }

    public long getMaxVerticesPerTransfer() {
        return this.maxVerticesPerTransfer;
    }

    public long getTotalEdges() {
        return this.totalEdgeCount;
    }

    public long getTotalVertices() {
        return this.totalVertexCount;
    }
}

