/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexChanges;
import org.apache.giraph.graph.VertexResolver;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class DefaultVertexResolver<I extends WritableComparable, V extends Writable, E extends Writable>
extends DefaultImmutableClassesGiraphConfigurable<I, V, E>
implements VertexResolver<I, V, E> {
    private static final Logger LOG = Logger.getLogger(DefaultVertexResolver.class);
    private boolean createVertexesOnMessages = true;

    @Override
    public Vertex<I, V, E> resolve(I vertexId, Vertex<I, V, E> vertex, VertexChanges<I, V, E> vertexChanges, boolean hasMessages) {
        this.removeEdges(vertex, vertexChanges);
        vertex = this.removeVertexIfDesired(vertex, vertexChanges);
        vertex = this.addVertexIfDesired(vertexId, vertex, vertexChanges, hasMessages);
        this.addEdges(vertex, vertexChanges);
        return vertex;
    }

    protected void removeEdges(Vertex<I, V, E> vertex, VertexChanges<I, V, E> vertexChanges) {
        if (vertex == null) {
            return;
        }
        if (this.hasEdgeRemovals(vertexChanges)) {
            for (WritableComparable removedDestVertex : vertexChanges.getRemovedEdgeList()) {
                vertex.removeEdges(removedDestVertex);
            }
        }
    }

    protected Vertex<I, V, E> removeVertexIfDesired(Vertex<I, V, E> vertex, VertexChanges<I, V, E> vertexChanges) {
        if (this.hasVertexRemovals(vertexChanges)) {
            vertex = null;
        }
        return vertex;
    }

    protected Vertex<I, V, E> addVertexIfDesired(I vertexId, Vertex<I, V, E> vertex, VertexChanges<I, V, E> vertexChanges, boolean hasMessages) {
        if (vertex == null) {
            if (this.hasVertexAdditions(vertexChanges)) {
                vertex = vertexChanges.getAddedVertexList().get(0);
            } else if (hasMessages && this.createVertexesOnMessages || this.hasEdgeAdditions(vertexChanges)) {
                vertex = this.getConf().createVertex();
                vertex.initialize(vertexId, this.getConf().createVertexValue());
            }
        } else if (this.hasVertexAdditions(vertexChanges)) {
            LOG.warn((Object)("resolve: Tried to add a vertex with id = " + vertex.getId() + " when one already " + "exists.  Ignoring the add vertex request."));
        }
        return vertex;
    }

    protected void addEdges(Vertex<I, V, E> vertex, VertexChanges<I, V, E> vertexChanges) {
        if (vertex == null) {
            return;
        }
        if (this.hasEdgeAdditions(vertexChanges)) {
            for (Edge<I, E> edge : vertexChanges.getAddedEdgeList()) {
                vertex.addEdge(edge);
            }
        }
    }

    protected boolean hasVertexRemovals(VertexChanges<I, V, E> changes) {
        return changes != null && changes.getRemovedVertexCount() > 0;
    }

    protected boolean hasVertexAdditions(VertexChanges<I, V, E> changes) {
        return changes != null && !changes.getAddedVertexList().isEmpty();
    }

    protected boolean hasEdgeAdditions(VertexChanges<I, V, E> changes) {
        return changes != null && !changes.getAddedEdgeList().isEmpty();
    }

    protected boolean hasEdgeRemovals(VertexChanges<I, V, E> changes) {
        return changes != null && !changes.getRemovedEdgeList().isEmpty();
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        super.setConf(conf);
        this.createVertexesOnMessages = conf.getResolverCreateVertexOnMessages();
    }
}

