/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.MultiRandomAccessOutEdges;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.MutableEdgesIterable;
import org.apache.giraph.edge.MutableEdgesWrapper;
import org.apache.giraph.edge.MutableOutEdges;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.edge.StrictRandomAccessOutEdges;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.utils.Trimmable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class DefaultVertex<I extends WritableComparable, V extends Writable, E extends Writable>
extends DefaultImmutableClassesGiraphConfigurable<I, V, E>
implements Vertex<I, V, E>,
Trimmable {
    private I id;
    private V value;
    private OutEdges<I, E> edges;
    private boolean halt;

    @Override
    public void initialize(I id, V value, Iterable<Edge<I, E>> edges) {
        this.id = id;
        this.value = value;
        this.setEdges(edges);
    }

    @Override
    public void initialize(I id, V value) {
        this.id = id;
        this.value = value;
        this.edges = this.getConf().createAndInitializeOutEdges(0);
    }

    @Override
    public void setEdges(Iterable<Edge<I, E>> edges) {
        this.edges = edges instanceof OutEdges ? (OutEdges)edges : this.getConf().createAndInitializeOutEdges(edges);
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        this.value = value;
    }

    @Override
    public Iterable<Edge<I, E>> getEdges() {
        return this.edges;
    }

    @Override
    public Iterable<MutableEdge<I, E>> getMutableEdges() {
        if (this.edges instanceof MutableOutEdges) {
            return new Iterable<MutableEdge<I, E>>(){

                @Override
                public Iterator<MutableEdge<I, E>> iterator() {
                    return ((MutableOutEdges)DefaultVertex.this.edges).mutableIterator();
                }
            };
        }
        return new MutableEdgesIterable(this);
    }

    @Override
    public void unwrapMutableEdges() {
        if (this.edges instanceof MutableEdgesWrapper) {
            this.edges = ((MutableEdgesWrapper)this.edges).unwrap();
        }
    }

    @Override
    public int getNumEdges() {
        return this.edges.size();
    }

    @Override
    public E getEdgeValue(I targetVertexId) {
        if (this.edges instanceof StrictRandomAccessOutEdges) {
            return ((StrictRandomAccessOutEdges)this.edges).getEdgeValue(targetVertexId);
        }
        for (Edge edge : this.edges) {
            if (!edge.getTargetVertexId().equals(targetVertexId)) continue;
            return edge.getValue();
        }
        return null;
    }

    @Override
    public void setEdgeValue(I targetVertexId, E edgeValue) {
        if (this.edges instanceof StrictRandomAccessOutEdges) {
            ((StrictRandomAccessOutEdges)this.edges).setEdgeValue(targetVertexId, edgeValue);
        } else {
            for (MutableEdge<I, E> edge : this.getMutableEdges()) {
                if (!edge.getTargetVertexId().equals(targetVertexId)) continue;
                edge.setValue(edgeValue);
            }
        }
    }

    @Override
    public Iterable<E> getAllEdgeValues(I targetVertexId) {
        if (this.edges instanceof MultiRandomAccessOutEdges) {
            return ((MultiRandomAccessOutEdges)this.edges).getAllEdgeValues(targetVertexId);
        }
        return new Iterable<E>((WritableComparable)targetVertexId){
            final /* synthetic */ WritableComparable val$targetVertexId;
            {
                this.val$targetVertexId = writableComparable;
            }

            @Override
            public Iterator<E> iterator() {
                return new UnmodifiableIterator<E>(){
                    private Iterator<Edge<I, E>> edgeIterator;
                    private Edge<I, E> currentEdge;
                    {
                        this.edgeIterator = DefaultVertex.this.edges.iterator();
                    }

                    public boolean hasNext() {
                        while (this.edgeIterator.hasNext()) {
                            this.currentEdge = this.edgeIterator.next();
                            if (!this.currentEdge.getTargetVertexId().equals(val$targetVertexId)) continue;
                            return true;
                        }
                        return false;
                    }

                    public E next() {
                        return this.currentEdge.getValue();
                    }
                };
            }
        };
    }

    @Override
    public void voteToHalt() {
        this.halt = true;
    }

    @Override
    public void wakeUp() {
        this.halt = false;
    }

    @Override
    public boolean isHalted() {
        return this.halt;
    }

    @Override
    public void trim() {
        if (this.edges instanceof Trimmable) {
            ((Trimmable)((Object)this.edges)).trim();
        }
    }

    @Override
    public void addEdge(Edge<I, E> edge) {
        this.edges.add(edge);
    }

    @Override
    public void removeEdges(I targetVertexId) {
        this.edges.remove(targetVertexId);
    }

    public String toString() {
        return "Vertex(id=" + this.getId() + ",value=" + this.getValue() + ",#edges=" + this.getNumEdges() + ")";
    }
}

