/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.yammer.metrics.core.Counter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.netty.NettyWorkerClientRequestProcessor;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.GraphState;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.SimpleVertexWriter;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.metrics.SuperstepMetricsRegistry;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionStats;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;
import org.apache.giraph.time.Times;
import org.apache.giraph.utils.MemoryUtils;
import org.apache.giraph.utils.TimedLogger;
import org.apache.giraph.utils.Trimmable;
import org.apache.giraph.worker.WorkerContext;
import org.apache.giraph.worker.WorkerProgress;
import org.apache.giraph.worker.WorkerThreadGlobalCommUsage;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;

public class ComputeCallable<I extends WritableComparable, V extends Writable, E extends Writable, M1 extends Writable, M2 extends Writable>
implements Callable<Collection<PartitionStats>> {
    private static final Logger LOG = Logger.getLogger(ComputeCallable.class);
    private static final Time TIME = SystemTime.get();
    private static final long VERTICES_TO_UPDATE_PROGRESS = 100000L;
    private final Mapper.Context context;
    private final GraphState graphState;
    private final BlockingQueue<Integer> partitionIdQueue;
    private final MessageStore<I, M1> messageStore;
    private final ImmutableClassesGiraphConfiguration<I, V, E> configuration;
    private final CentralizedServiceWorker<I, V, E> serviceWorker;
    private final TimedLogger timedLogger = new TimedLogger(30000, LOG);
    private SimpleVertexWriter<I, V, E> vertexWriter;
    private final long startNanos = TIME.getNanoseconds();
    private final Counter messagesSentCounter;
    private final Counter messageBytesSentCounter;

    public ComputeCallable(Mapper.Context context, GraphState graphState, MessageStore<I, M1> messageStore, BlockingQueue<Integer> partitionIdQueue, ImmutableClassesGiraphConfiguration<I, V, E> configuration, CentralizedServiceWorker<I, V, E> serviceWorker) {
        this.context = context;
        this.configuration = configuration;
        this.partitionIdQueue = partitionIdQueue;
        this.messageStore = messageStore;
        this.serviceWorker = serviceWorker;
        this.graphState = graphState;
        SuperstepMetricsRegistry metrics = GiraphMetrics.get().perSuperstep();
        this.messagesSentCounter = metrics.getCounter("messages-sent");
        this.messageBytesSentCounter = metrics.getCounter("message-bytes-sent");
    }

    @Override
    public Collection<PartitionStats> call() {
        Integer partitionId;
        NettyWorkerClientRequestProcessor<I, V, E> workerClientRequestProcessor = new NettyWorkerClientRequestProcessor<I, V, E>(this.context, this.configuration, this.serviceWorker);
        WorkerThreadGlobalCommUsage aggregatorUsage = this.serviceWorker.getAggregatorHandler().newThreadAggregatorUsage();
        WorkerContext workerContext = this.serviceWorker.getWorkerContext();
        this.vertexWriter = this.serviceWorker.getSuperstepOutput().getVertexWriter();
        ArrayList partitionStatsList = Lists.newArrayList();
        while (!this.partitionIdQueue.isEmpty() && (partitionId = (Integer)this.partitionIdQueue.poll()) != null) {
            Partition<I, V, E> partition = this.serviceWorker.getPartitionStore().getOrCreatePartition(partitionId);
            Computation<I, V, E, Writable, Writable> computation = this.configuration.createComputation();
            computation.initialize(this.graphState, workerClientRequestProcessor, this.serviceWorker.getGraphTaskManager(), aggregatorUsage, workerContext);
            computation.preSuperstep();
            try {
                PartitionStats partitionStats = this.computePartition(computation, partition);
                partitionStatsList.add(partitionStats);
                long partitionMsgs = workerClientRequestProcessor.resetMessageCount();
                partitionStats.addMessagesSentCount(partitionMsgs);
                this.messagesSentCounter.inc(partitionMsgs);
                long partitionMsgBytes = workerClientRequestProcessor.resetMessageBytesCount();
                partitionStats.addMessageBytesSentCount(partitionMsgBytes);
                this.messageBytesSentCounter.inc(partitionMsgBytes);
                this.timedLogger.info("call: Completed " + partitionStatsList.size() + " partitions, " + this.partitionIdQueue.size() + " remaining " + MemoryUtils.getRuntimeMemoryStats());
            }
            catch (IOException e) {
                throw new IllegalStateException("call: Caught unexpected IOException, failing.", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("call: Caught unexpected InterruptedException, failing.", e);
            }
            finally {
                this.serviceWorker.getPartitionStore().putPartition(partition);
            }
            computation.postSuperstep();
        }
        this.serviceWorker.getSuperstepOutput().returnVertexWriter(this.vertexWriter);
        if (LOG.isInfoEnabled()) {
            float seconds = (float)Times.getNanosSince(TIME, this.startNanos) / 1.0E9f;
            LOG.info((Object)("call: Computation took " + seconds + " secs for " + partitionStatsList.size() + " partitions on superstep " + this.graphState.getSuperstep() + ".  Flushing started"));
        }
        try {
            workerClientRequestProcessor.flush();
            if (partitionStatsList.size() > 0) {
                long partitionMsgBytes = workerClientRequestProcessor.resetMessageBytesCount();
                ((PartitionStats)partitionStatsList.get(partitionStatsList.size() - 1)).addMessageBytesSentCount(partitionMsgBytes);
                this.messageBytesSentCounter.inc(partitionMsgBytes);
            }
            aggregatorUsage.finishThreadComputation();
        }
        catch (IOException e) {
            throw new IllegalStateException("call: Flushing failed.", e);
        }
        return partitionStatsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartitionStats computePartition(Computation<I, V, E, M1, M2> computation, Partition<I, V, E> partition) throws IOException, InterruptedException {
        PartitionStats partitionStats = new PartitionStats(partition.getId(), 0L, 0L, 0L, 0L, 0L);
        long verticesComputedProgress = 0L;
        Partition<I, V, E> partition2 = partition;
        synchronized (partition2) {
            for (Vertex vertex : partition) {
                Iterable<M1> messages = this.messageStore.getVertexMessages(vertex.getId());
                if (vertex.isHalted() && !Iterables.isEmpty(messages)) {
                    vertex.wakeUp();
                }
                if (!vertex.isHalted()) {
                    this.context.progress();
                    computation.compute(vertex, messages);
                    vertex.unwrapMutableEdges();
                    if (vertex instanceof Trimmable) {
                        ((Trimmable)((Object)vertex)).trim();
                    }
                    this.vertexWriter.writeVertex(vertex);
                    partition.saveVertex(vertex);
                }
                if (vertex.isHalted()) {
                    partitionStats.incrFinishedVertexCount();
                }
                this.messageStore.clearVertexMessages(vertex.getId());
                partitionStats.incrVertexCount();
                partitionStats.addEdgeCount(vertex.getNumEdges());
                if (++verticesComputedProgress != 100000L) continue;
                WorkerProgress.get().addVerticesComputed(verticesComputedProgress);
                verticesComputedProgress = 0L;
            }
            this.messageStore.clearPartition(partition.getId());
        }
        WorkerProgress.get().addVerticesComputed(verticesComputedProgress);
        WorkerProgress.get().incrementPartitionsComputed();
        return partitionStats;
    }
}

