/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.comm.WorkerClientRequestProcessor;
import org.apache.giraph.conf.ImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.TypesHolder;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.GraphState;
import org.apache.giraph.graph.GraphTaskManager;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.worker.WorkerAggregatorUsage;
import org.apache.giraph.worker.WorkerContext;
import org.apache.giraph.worker.WorkerGlobalCommUsage;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;

public interface Computation<I extends WritableComparable, V extends Writable, E extends Writable, M1 extends Writable, M2 extends Writable>
extends TypesHolder<I, V, E, M1, M2>,
ImmutableClassesGiraphConfigurable<I, V, E>,
WorkerGlobalCommUsage,
WorkerAggregatorUsage {
    public void compute(Vertex<I, V, E> var1, Iterable<M1> var2) throws IOException;

    public void preSuperstep();

    public void postSuperstep();

    public void initialize(GraphState var1, WorkerClientRequestProcessor<I, V, E> var2, GraphTaskManager<I, V, E> var3, WorkerGlobalCommUsage var4, WorkerContext var5);

    public long getSuperstep();

    public long getTotalNumVertices();

    public long getTotalNumEdges();

    public void sendMessage(I var1, M2 var2);

    public void sendMessageToAllEdges(Vertex<I, V, E> var1, M2 var2);

    public void sendMessageToMultipleEdges(Iterator<I> var1, M2 var2);

    public void addVertexRequest(I var1, V var2, OutEdges<I, E> var3) throws IOException;

    public void addVertexRequest(I var1, V var2) throws IOException;

    public void removeVertexRequest(I var1) throws IOException;

    public void addEdgeRequest(I var1, Edge<I, E> var2) throws IOException;

    public void removeEdgesRequest(I var1, I var2) throws IOException;

    public Mapper.Context getContext();

    public <W extends WorkerContext> W getWorkerContext();
}

