/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.DefaultVertex;
import org.apache.giraph.utils.UnsafeByteArrayInputStream;
import org.apache.giraph.utils.UnsafeByteArrayOutputStream;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class ByteValueVertex<I extends WritableComparable, V extends Writable, E extends Writable>
extends DefaultVertex<I, V, E> {
    private byte[] valueBytes;
    private V cachedValue = null;

    @Override
    public V getValue() {
        if (this.cachedValue != null) {
            return this.cachedValue;
        }
        UnsafeByteArrayInputStream dis = new UnsafeByteArrayInputStream(this.valueBytes);
        this.cachedValue = this.getConf().createVertexValue();
        try {
            this.cachedValue.readFields((DataInput)dis);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not deserialize vertex value", ioe);
        }
        this.valueBytes = null;
        return this.cachedValue;
    }

    private void setSerializedValue(V value) {
        UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream();
        try {
            value.write((DataOutput)bos);
            bos.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not serialize vertex value", ioe);
        }
        this.valueBytes = bos.toByteArray();
        this.cachedValue = null;
    }

    @Override
    public void setValue(V value) {
        if (this.cachedValue != null) {
            this.cachedValue = value;
        } else {
            this.setSerializedValue(value);
        }
    }

    @Override
    public void initialize(I id, V value, Iterable<Edge<I, E>> edges) {
        super.initialize(id, null, edges);
        this.setValue(value);
    }

    @Override
    public void initialize(I id, V value) {
        super.initialize(id, null);
        this.setValue(value);
    }

    @Override
    public void unwrapMutableEdges() {
        if (this.cachedValue != null) {
            this.setSerializedValue(this.cachedValue);
            this.cachedValue = null;
        }
        super.unwrapMutableEdges();
    }
}

