/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.giraph.master.MasterInfo;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;

public class AddressesAndPartitionsWritable
implements Writable {
    private MasterInfo masterInfo;
    private List<WorkerInfo> workerInfos;
    private Collection<PartitionOwner> partitionOwners;
    private Class<? extends PartitionOwner> partitionOwnerClass;

    public AddressesAndPartitionsWritable(MasterInfo masterInfo, List<WorkerInfo> workerInfos, Collection<PartitionOwner> partitionOwners) {
        this.masterInfo = masterInfo;
        this.workerInfos = workerInfos;
        this.partitionOwners = partitionOwners;
    }

    public AddressesAndPartitionsWritable(Class<? extends PartitionOwner> partitionOwnerClass) {
        this.partitionOwnerClass = partitionOwnerClass;
    }

    public MasterInfo getMasterInfo() {
        return this.masterInfo;
    }

    public List<WorkerInfo> getWorkerInfos() {
        return this.workerInfos;
    }

    public Collection<PartitionOwner> getPartitionOwners() {
        return this.partitionOwners;
    }

    public void write(DataOutput output) throws IOException {
        this.masterInfo.write(output);
        output.writeInt(this.workerInfos.size());
        for (WorkerInfo workerInfo : this.workerInfos) {
            workerInfo.write(output);
        }
        Map<Integer, WorkerInfo> workerInfoMap = AddressesAndPartitionsWritable.getAsWorkerInfoMap(this.workerInfos);
        ArrayList previousWorkerInfos = Lists.newArrayList();
        for (PartitionOwner partitionOwner : this.partitionOwners) {
            if (partitionOwner.getPreviousWorkerInfo() == null || workerInfoMap.containsKey(partitionOwner.getPreviousWorkerInfo().getTaskId())) continue;
            previousWorkerInfos.add(partitionOwner.getPreviousWorkerInfo());
        }
        output.writeInt(previousWorkerInfos.size());
        for (WorkerInfo workerInfo : previousWorkerInfos) {
            workerInfo.write(output);
        }
        output.writeInt(this.partitionOwners.size());
        for (PartitionOwner partitionOwner : this.partitionOwners) {
            partitionOwner.writeWithWorkerIds(output);
        }
    }

    public void readFields(DataInput input) throws IOException {
        this.masterInfo = new MasterInfo();
        this.masterInfo.readFields(input);
        int workerInfosSize = input.readInt();
        this.workerInfos = Lists.newArrayListWithCapacity((int)workerInfosSize);
        for (int i = 0; i < workerInfosSize; ++i) {
            WorkerInfo workerInfo = new WorkerInfo();
            workerInfo.readFields(input);
            this.workerInfos.add(workerInfo);
        }
        Map<Integer, WorkerInfo> workerInfoMap = AddressesAndPartitionsWritable.getAsWorkerInfoMap(this.workerInfos);
        int additionalWorkerInfos = input.readInt();
        for (int i = 0; i < additionalWorkerInfos; ++i) {
            WorkerInfo workerInfo = new WorkerInfo();
            workerInfo.readFields(input);
            workerInfoMap.put(workerInfo.getTaskId(), workerInfo);
        }
        int partitionOwnersSize = input.readInt();
        this.partitionOwners = Lists.newArrayListWithCapacity((int)partitionOwnersSize);
        for (int i = 0; i < partitionOwnersSize; ++i) {
            try {
                PartitionOwner partitionOwner = this.partitionOwnerClass.newInstance();
                partitionOwner.readFieldsWithWorkerIds(input, workerInfoMap);
                this.partitionOwners.add(partitionOwner);
                continue;
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("readFields: InstantiationException on partition owner class " + this.partitionOwnerClass, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("readFields: IllegalAccessException on partition owner class " + this.partitionOwnerClass, e);
            }
        }
    }

    private static Map<Integer, WorkerInfo> getAsWorkerInfoMap(Iterable<WorkerInfo> workerInfos) {
        HashMap workerInfoMap = Maps.newHashMapWithExpectedSize((int)Iterables.size(workerInfos));
        for (WorkerInfo workerInfo : workerInfos) {
            workerInfoMap.put(workerInfo.getTaskId(), workerInfo);
        }
        return workerInfoMap;
    }
}

