/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.comm.WorkerClientRequestProcessor;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.GraphState;
import org.apache.giraph.graph.GraphTaskManager;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.worker.WorkerAggregatorDelegator;
import org.apache.giraph.worker.WorkerContext;
import org.apache.giraph.worker.WorkerGlobalCommUsage;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;

public abstract class AbstractComputation<I extends WritableComparable, V extends Writable, E extends Writable, M1 extends Writable, M2 extends Writable>
extends WorkerAggregatorDelegator<I, V, E>
implements Computation<I, V, E, M1, M2> {
    private static final Logger LOG = Logger.getLogger(AbstractComputation.class);
    private GraphState graphState;
    private WorkerClientRequestProcessor<I, V, E> workerClientRequestProcessor;
    private GraphTaskManager<I, V, E> graphTaskManager;
    private WorkerContext workerContext;

    @Override
    public abstract void compute(Vertex<I, V, E> var1, Iterable<M1> var2) throws IOException;

    @Override
    public void preSuperstep() {
    }

    @Override
    public void postSuperstep() {
    }

    @Override
    public void initialize(GraphState graphState, WorkerClientRequestProcessor<I, V, E> workerClientRequestProcessor, GraphTaskManager<I, V, E> graphTaskManager, WorkerGlobalCommUsage workerGlobalCommUsage, WorkerContext workerContext) {
        this.graphState = graphState;
        this.workerClientRequestProcessor = workerClientRequestProcessor;
        this.graphTaskManager = graphTaskManager;
        this.setWorkerGlobalCommUsage(workerGlobalCommUsage);
        this.workerContext = workerContext;
    }

    @Override
    public long getSuperstep() {
        return this.graphState.getSuperstep();
    }

    @Override
    public long getTotalNumVertices() {
        return this.graphState.getTotalNumVertices();
    }

    @Override
    public long getTotalNumEdges() {
        return this.graphState.getTotalNumEdges();
    }

    @Override
    public void sendMessage(I id, M2 message) {
        this.workerClientRequestProcessor.sendMessageRequest(id, (Writable)message);
    }

    @Override
    public void sendMessageToAllEdges(Vertex<I, V, E> vertex, M2 message) {
        this.workerClientRequestProcessor.sendMessageToAllRequest(vertex, (Writable)message);
    }

    @Override
    public void sendMessageToMultipleEdges(Iterator<I> vertexIdIterator, M2 message) {
        this.workerClientRequestProcessor.sendMessageToAllRequest(vertexIdIterator, (Writable)message);
    }

    @Override
    public void addVertexRequest(I id, V value, OutEdges<I, E> edges) throws IOException {
        Vertex vertex = this.getConf().createVertex();
        vertex.initialize(id, value, edges);
        this.workerClientRequestProcessor.addVertexRequest(vertex);
    }

    @Override
    public void addVertexRequest(I id, V value) throws IOException {
        this.addVertexRequest(id, value, this.getConf().createAndInitializeOutEdges());
    }

    @Override
    public void removeVertexRequest(I vertexId) throws IOException {
        this.workerClientRequestProcessor.removeVertexRequest(vertexId);
    }

    @Override
    public void addEdgeRequest(I sourceVertexId, Edge<I, E> edge) throws IOException {
        this.workerClientRequestProcessor.addEdgeRequest(sourceVertexId, edge);
    }

    @Override
    public void removeEdgesRequest(I sourceVertexId, I targetVertexId) throws IOException {
        this.workerClientRequestProcessor.removeEdgesRequest(sourceVertexId, targetVertexId);
    }

    @Override
    public Mapper.Context getContext() {
        return this.graphState.getContext();
    }

    @Override
    public <W extends WorkerContext> W getWorkerContext() {
        return (W)this.workerContext;
    }
}

