/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.factories;

import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.EdgeValueFactory;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.factories.VertexIdFactory;
import org.apache.giraph.factories.VertexValueFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class ValueFactories<I extends WritableComparable, V extends Writable, E extends Writable> {
    private final VertexIdFactory<I> vertexIdFactory;
    private final VertexValueFactory<V> vertexValueFactory;
    private final EdgeValueFactory<E> edgeValueFactory;
    private final Class<? extends MessageValueFactory> inMsgFactoryClass;
    private final Class<? extends MessageValueFactory> outMsgFactoryClass;

    public ValueFactories(Configuration conf) {
        this.vertexIdFactory = GiraphConstants.VERTEX_ID_FACTORY_CLASS.newInstance(conf);
        this.vertexValueFactory = GiraphConstants.VERTEX_VALUE_FACTORY_CLASS.newInstance(conf);
        this.edgeValueFactory = GiraphConstants.EDGE_VALUE_FACTORY_CLASS.newInstance(conf);
        this.inMsgFactoryClass = GiraphConstants.INCOMING_MESSAGE_VALUE_FACTORY_CLASS.get(conf);
        this.outMsgFactoryClass = GiraphConstants.OUTGOING_MESSAGE_VALUE_FACTORY_CLASS.get(conf);
    }

    public void initializeIVE(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        this.vertexIdFactory.initialize(conf);
        this.vertexValueFactory.initialize(conf);
        this.edgeValueFactory.initialize(conf);
    }

    public EdgeValueFactory<E> getEdgeValueFactory() {
        return this.edgeValueFactory;
    }

    public VertexIdFactory<I> getVertexIdFactory() {
        return this.vertexIdFactory;
    }

    public VertexValueFactory<V> getVertexValueFactory() {
        return this.vertexValueFactory;
    }

    public Class<? extends MessageValueFactory> getInMsgFactoryClass() {
        return this.inMsgFactoryClass;
    }

    public Class<? extends MessageValueFactory> getOutMsgFactoryClass() {
        return this.outMsgFactoryClass;
    }
}

