/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.factories;

import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.ComputationFactory;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class DefaultComputationFactory<I extends WritableComparable, V extends Writable, E extends Writable>
implements ComputationFactory<I, V, E, Writable, Writable> {
    @Override
    public void initialize(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
    }

    @Override
    public Computation<I, V, E, Writable, Writable> createComputation(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        Class<Computation<I, V, E, Writable, Writable>> klass = conf.getComputationClass();
        return ReflectionUtils.newInstance(klass, conf);
    }

    @Override
    public void checkConfiguration(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        if (conf.getComputationClass() == null) {
            throw new IllegalArgumentException("checkConfiguration: Null " + GiraphConstants.COMPUTATION_CLASS.getKey());
        }
    }

    @Override
    public String computationName(GiraphConfiguration conf) {
        return conf.getComputationClass().getSimpleName();
    }
}

