/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.factories;

import com.google.common.base.Objects;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;

public abstract class AbstractMessageValueFactory<M extends Writable>
implements MessageValueFactory<M> {
    private Class<M> messageValueClass;

    protected abstract Class<M> extractMessageValueClass(ImmutableClassesGiraphConfiguration var1);

    @Override
    public Class<M> getValueClass() {
        return this.messageValueClass;
    }

    @Override
    public void initialize(ImmutableClassesGiraphConfiguration conf) {
        this.messageValueClass = this.extractMessageValueClass(conf);
    }

    @Override
    public M newInstance() {
        return WritableUtils.createWritable(this.messageValueClass);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("messageValueClass", this.messageValueClass).toString();
    }
}

