/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge.primitives;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.AbstractEdgeStore;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.utils.VertexIdEdgeIterator;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Progressable;

public class LongEdgeStore<V extends Writable, E extends Writable>
extends AbstractEdgeStore<LongWritable, V, E, Long, Long2ObjectMap.Entry<OutEdges<LongWritable, E>>> {
    public LongEdgeStore(CentralizedServiceWorker<LongWritable, V, E> service, ImmutableClassesGiraphConfiguration<LongWritable, V, E> configuration, Progressable progressable) {
        super(service, configuration, progressable);
    }

    @Override
    protected LongWritable getVertexId(Long2ObjectMap.Entry<OutEdges<LongWritable, E>> entry, LongWritable representativeVertexId) {
        representativeVertexId.set(entry.getLongKey());
        return representativeVertexId;
    }

    @Override
    protected LongWritable createVertexId(Long2ObjectMap.Entry<OutEdges<LongWritable, E>> entry) {
        return new LongWritable(entry.getLongKey());
    }

    @Override
    protected OutEdges<LongWritable, E> getPartitionEdges(Long2ObjectMap.Entry<OutEdges<LongWritable, E>> entry) {
        return (OutEdges)entry.getValue();
    }

    @Override
    protected Iterator<Long2ObjectMap.Entry<OutEdges<LongWritable, E>>> getPartitionEdgesIterator(Map<Long, OutEdges<LongWritable, E>> partitionEdges) {
        return ((Long2ObjectMap)partitionEdges).long2ObjectEntrySet().iterator();
    }

    protected Long2ObjectMap<OutEdges<LongWritable, E>> getPartitionEdges(int partitionId) {
        Long2ObjectMap partitionEdges = (Long2ObjectMap)this.transientEdges.get(partitionId);
        if (partitionEdges == null) {
            Long2ObjectMap newPartitionEdges = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
            partitionEdges = this.transientEdges.putIfAbsent(partitionId, newPartitionEdges);
            if (partitionEdges == null) {
                partitionEdges = newPartitionEdges;
            }
        }
        return partitionEdges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OutEdges<LongWritable, E> getVertexOutEdges(VertexIdEdgeIterator<LongWritable, E> vertexIdEdgeIterator, Map<Long, OutEdges<LongWritable, E>> partitionEdgesIn) {
        Long2ObjectMap partitionEdges = (Long2ObjectMap)partitionEdgesIn;
        LongWritable vertexId = (LongWritable)vertexIdEdgeIterator.getCurrentVertexId();
        OutEdges outEdges = (OutEdges)partitionEdges.get(vertexId.get());
        if (outEdges == null) {
            Long2ObjectMap long2ObjectMap = partitionEdges;
            synchronized (long2ObjectMap) {
                outEdges = (OutEdges)partitionEdges.get(vertexId.get());
                if (outEdges == null) {
                    outEdges = this.configuration.createAndInitializeInputOutEdges();
                    partitionEdges.put(vertexId.get(), outEdges);
                }
            }
        }
        return outEdges;
    }
}

