/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge.primitives;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.AbstractEdgeStore;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.utils.VertexIdEdgeIterator;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Progressable;

public class IntEdgeStore<V extends Writable, E extends Writable>
extends AbstractEdgeStore<IntWritable, V, E, Integer, Int2ObjectMap.Entry<OutEdges<IntWritable, E>>> {
    public IntEdgeStore(CentralizedServiceWorker<IntWritable, V, E> service, ImmutableClassesGiraphConfiguration<IntWritable, V, E> configuration, Progressable progressable) {
        super(service, configuration, progressable);
    }

    @Override
    protected IntWritable getVertexId(Int2ObjectMap.Entry<OutEdges<IntWritable, E>> entry, IntWritable representativeVertexId) {
        representativeVertexId.set(entry.getIntKey());
        return representativeVertexId;
    }

    @Override
    protected IntWritable createVertexId(Int2ObjectMap.Entry<OutEdges<IntWritable, E>> entry) {
        return new IntWritable(entry.getIntKey());
    }

    @Override
    protected OutEdges<IntWritable, E> getPartitionEdges(Int2ObjectMap.Entry<OutEdges<IntWritable, E>> entry) {
        return (OutEdges)entry.getValue();
    }

    @Override
    protected Iterator<Int2ObjectMap.Entry<OutEdges<IntWritable, E>>> getPartitionEdgesIterator(Map<Integer, OutEdges<IntWritable, E>> partitionEdges) {
        return ((Int2ObjectMap)partitionEdges).int2ObjectEntrySet().iterator();
    }

    protected Int2ObjectMap<OutEdges<IntWritable, E>> getPartitionEdges(int partitionId) {
        Int2ObjectMap partitionEdges = (Int2ObjectMap)this.transientEdges.get(partitionId);
        if (partitionEdges == null) {
            Int2ObjectMap newPartitionEdges = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
            partitionEdges = this.transientEdges.putIfAbsent(partitionId, newPartitionEdges);
            if (partitionEdges == null) {
                partitionEdges = newPartitionEdges;
            }
        }
        return partitionEdges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OutEdges<IntWritable, E> getVertexOutEdges(VertexIdEdgeIterator<IntWritable, E> vertexIdEdgeIterator, Map<Integer, OutEdges<IntWritable, E>> partitionEdgesIn) {
        Int2ObjectMap partitionEdges = (Int2ObjectMap)partitionEdgesIn;
        IntWritable vertexId = (IntWritable)vertexIdEdgeIterator.getCurrentVertexId();
        OutEdges outEdges = (OutEdges)partitionEdges.get(vertexId.get());
        if (outEdges == null) {
            Int2ObjectMap int2ObjectMap = partitionEdges;
            synchronized (int2ObjectMap) {
                outEdges = (OutEdges)partitionEdges.get(vertexId.get());
                if (outEdges == null) {
                    outEdges = this.configuration.createAndInitializeInputOutEdges();
                    partitionEdges.put(vertexId.get(), outEdges);
                }
            }
        }
        return outEdges;
    }
}

