/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.MapMaker;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.AbstractEdgeStore;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.utils.VertexIdEdgeIterator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.Progressable;

public class SimpleEdgeStore<I extends WritableComparable, V extends Writable, E extends Writable>
extends AbstractEdgeStore<I, V, E, I, Map.Entry<I, OutEdges<I, E>>> {
    public SimpleEdgeStore(CentralizedServiceWorker<I, V, E> service, ImmutableClassesGiraphConfiguration<I, V, E> configuration, Progressable progressable) {
        super(service, configuration, progressable);
    }

    @Override
    protected I getVertexId(Map.Entry<I, OutEdges<I, E>> entry, I representativeVertexId) {
        return (I)((WritableComparable)entry.getKey());
    }

    @Override
    protected I createVertexId(Map.Entry<I, OutEdges<I, E>> entry) {
        return (I)((WritableComparable)entry.getKey());
    }

    @Override
    protected ConcurrentMap<I, OutEdges<I, E>> getPartitionEdges(int partitionId) {
        ConcurrentMap partitionEdges = (ConcurrentMap)this.transientEdges.get(partitionId);
        if (partitionEdges == null) {
            ConcurrentMap newPartitionEdges = new MapMaker().concurrencyLevel(this.configuration.getNettyServerExecutionConcurrency()).makeMap();
            partitionEdges = this.transientEdges.putIfAbsent(partitionId, newPartitionEdges);
            if (partitionEdges == null) {
                partitionEdges = newPartitionEdges;
            }
        }
        return partitionEdges;
    }

    @Override
    protected OutEdges<I, E> getPartitionEdges(Map.Entry<I, OutEdges<I, E>> entry) {
        return entry.getValue();
    }

    @Override
    protected Iterator<Map.Entry<I, OutEdges<I, E>>> getPartitionEdgesIterator(Map<I, OutEdges<I, E>> partitionEdges) {
        return partitionEdges.entrySet().iterator();
    }

    @Override
    protected OutEdges<I, E> getVertexOutEdges(VertexIdEdgeIterator<I, E> vertexIdEdgeIterator, Map<I, OutEdges<I, E>> partitionEdgesIn) {
        OutEdges newOutEdges;
        ConcurrentMap partitionEdges = (ConcurrentMap)partitionEdgesIn;
        Object vertexId = vertexIdEdgeIterator.getCurrentVertexId();
        OutEdges outEdges = (OutEdges)partitionEdges.get(vertexId);
        if (outEdges == null && (outEdges = partitionEdges.putIfAbsent(vertexId, newOutEdges = this.configuration.createAndInitializeInputOutEdges())) == null) {
            outEdges = newOutEdges;
            vertexIdEdgeIterator.releaseCurrentVertexId();
        }
        return outEdges;
    }
}

