/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.OutEdges;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class MutableEdgesWrapper<I extends WritableComparable, E extends Writable>
implements OutEdges<I, E> {
    private final OutEdges<I, E> newEdges;
    private final Iterator<Edge<I, E>> oldEdgesIterator;
    private MutableEdge<I, E> currentEdge;
    private int numEdges;

    private MutableEdgesWrapper(OutEdges<I, E> oldEdges, OutEdges<I, E> newEdges) {
        this.oldEdgesIterator = oldEdges.iterator();
        this.newEdges = newEdges;
        this.numEdges = oldEdges.size();
    }

    public static <I extends WritableComparable, E extends Writable> MutableEdgesWrapper<I, E> wrap(OutEdges<I, E> edges, ImmutableClassesGiraphConfiguration<I, ?, E> conf) {
        MutableEdgesWrapper<I, E> wrapper = new MutableEdgesWrapper<I, E>(edges, conf.createAndInitializeOutEdges(edges.size()));
        return wrapper;
    }

    public OutEdges<I, E> unwrap() {
        if (this.currentEdge != null) {
            this.newEdges.add(this.currentEdge);
            this.currentEdge = null;
        }
        while (this.oldEdgesIterator.hasNext()) {
            this.newEdges.add(this.oldEdgesIterator.next());
        }
        return this.newEdges;
    }

    public OutEdges<I, E> getNewEdges() {
        return this.newEdges;
    }

    public Iterator<Edge<I, E>> getOldEdgesIterator() {
        return this.oldEdgesIterator;
    }

    public MutableEdge<I, E> getCurrentEdge() {
        return this.currentEdge;
    }

    public void setCurrentEdge(MutableEdge<I, E> edge) {
        this.currentEdge = edge;
    }

    public void decrementEdges() {
        --this.numEdges;
    }

    @Override
    public void initialize(Iterable<Edge<I, E>> edges) {
        throw new IllegalStateException("initialize: MutableEdgesWrapper should never be initialized.");
    }

    @Override
    public void initialize(int capacity) {
        throw new IllegalStateException("initialize: MutableEdgesWrapper should never be initialized.");
    }

    @Override
    public void initialize() {
        throw new IllegalStateException("initialize: MutableEdgesWrapper should never be initialized.");
    }

    @Override
    public void add(Edge<I, E> edge) {
        this.unwrap().add(edge);
    }

    @Override
    public void remove(I targetVertexId) {
        this.unwrap().remove(targetVertexId);
    }

    @Override
    public int size() {
        return this.numEdges;
    }

    @Override
    public Iterator<Edge<I, E>> iterator() {
        return this.unwrap().iterator();
    }

    public void write(DataOutput out) throws IOException {
        throw new IllegalStateException("write: MutableEdgesWrapper should never be serialized.");
    }

    public void readFields(DataInput in) throws IOException {
        throw new IllegalStateException("readFields: MutableEdgesWrapper should never be deserialized.");
    }
}

