/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import java.util.Iterator;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.MutableEdgesWrapper;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class MutableEdgesIterable<I extends WritableComparable, E extends Writable>
implements Iterable<MutableEdge<I, E>> {
    private Vertex<I, ?, E> vertex;

    public MutableEdgesIterable(Vertex<I, ?, E> vertex) {
        this.vertex = vertex;
    }

    @Override
    public Iterator<MutableEdge<I, E>> iterator() {
        final MutableEdgesWrapper mutableEdgesWrapper = MutableEdgesWrapper.wrap((OutEdges)this.vertex.getEdges(), this.vertex.getConf());
        this.vertex.setEdges(mutableEdgesWrapper);
        return new Iterator<MutableEdge<I, E>>(){
            private Iterator<Edge<I, E>> oldEdgesIterator;
            private OutEdges<I, E> newEdges;
            {
                this.oldEdgesIterator = mutableEdgesWrapper.getOldEdgesIterator();
                this.newEdges = mutableEdgesWrapper.getNewEdges();
            }

            @Override
            public boolean hasNext() {
                MutableEdge currentEdge = mutableEdgesWrapper.getCurrentEdge();
                if (currentEdge != null) {
                    this.newEdges.add(currentEdge);
                    mutableEdgesWrapper.setCurrentEdge(null);
                }
                if (!this.oldEdgesIterator.hasNext()) {
                    MutableEdgesIterable.this.vertex.setEdges(this.newEdges);
                    return false;
                }
                return true;
            }

            @Override
            public MutableEdge<I, E> next() {
                MutableEdge currentEdge = mutableEdgesWrapper.getCurrentEdge();
                if (currentEdge != null) {
                    this.newEdges.add(currentEdge);
                }
                currentEdge = (MutableEdge)this.oldEdgesIterator.next();
                mutableEdgesWrapper.setCurrentEdge(currentEdge);
                return currentEdge;
            }

            @Override
            public void remove() {
                mutableEdgesWrapper.setCurrentEdge(null);
                mutableEdgesWrapper.decrementEdges();
            }
        };
    }
}

