/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.MutableOutEdges;
import org.apache.giraph.edge.ReusableEdge;
import org.apache.giraph.edge.ReuseObjectsOutEdges;
import org.apache.giraph.edge.StrictRandomAccessOutEdges;
import org.apache.giraph.utils.EdgeIterables;
import org.apache.giraph.utils.Trimmable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;

public class LongNullHashSetEdges
implements ReuseObjectsOutEdges<LongWritable, NullWritable>,
MutableOutEdges<LongWritable, NullWritable>,
StrictRandomAccessOutEdges<LongWritable, NullWritable>,
Trimmable {
    private LongOpenHashSet neighbors;

    @Override
    public void initialize(Iterable<Edge<LongWritable, NullWritable>> edges) {
        EdgeIterables.initialize(this, edges);
    }

    @Override
    public void initialize(int capacity) {
        this.neighbors = new LongOpenHashSet(capacity);
    }

    @Override
    public void initialize() {
        this.neighbors = new LongOpenHashSet();
    }

    @Override
    public void add(Edge<LongWritable, NullWritable> edge) {
        this.neighbors.add(edge.getTargetVertexId().get());
    }

    @Override
    public void remove(LongWritable targetVertexId) {
        this.neighbors.remove(targetVertexId.get());
    }

    @Override
    public int size() {
        return this.neighbors.size();
    }

    @Override
    public Iterator<Edge<LongWritable, NullWritable>> iterator() {
        return this.mutableIterator();
    }

    @Override
    public Iterator<MutableEdge<LongWritable, NullWritable>> mutableIterator() {
        return new Iterator<MutableEdge<LongWritable, NullWritable>>(){
            private LongIterator neighborsIt;
            private ReusableEdge<LongWritable, NullWritable> representativeEdge;
            {
                this.neighborsIt = LongNullHashSetEdges.this.neighbors.iterator();
                this.representativeEdge = EdgeFactory.createReusable(new LongWritable());
            }

            @Override
            public boolean hasNext() {
                return this.neighborsIt.hasNext();
            }

            @Override
            public MutableEdge<LongWritable, NullWritable> next() {
                ((LongWritable)this.representativeEdge.getTargetVertexId()).set(this.neighborsIt.nextLong());
                return this.representativeEdge;
            }

            @Override
            public void remove() {
                this.neighborsIt.remove();
            }
        };
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.neighbors.size());
        LongIterator neighborsIt = this.neighbors.iterator();
        while (neighborsIt.hasNext()) {
            out.writeLong(neighborsIt.nextLong());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numEdges = in.readInt();
        this.initialize(numEdges);
        for (int i = 0; i < numEdges; ++i) {
            this.neighbors.add(in.readLong());
        }
    }

    @Override
    public NullWritable getEdgeValue(LongWritable targetVertexId) {
        if (this.neighbors.contains(targetVertexId.get())) {
            return NullWritable.get();
        }
        return null;
    }

    @Override
    public void setEdgeValue(LongWritable targetVertexId, NullWritable edgeValue) {
    }

    @Override
    public void trim() {
        this.neighbors.trim();
    }
}

