/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.MutableOutEdges;
import org.apache.giraph.edge.ReuseObjectsOutEdges;
import org.apache.giraph.utils.EdgeIterables;
import org.apache.giraph.utils.Trimmable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;

public class LongNullArrayEdges
implements ReuseObjectsOutEdges<LongWritable, NullWritable>,
MutableOutEdges<LongWritable, NullWritable>,
Trimmable {
    private LongArrayList neighbors;

    @Override
    public void initialize(Iterable<Edge<LongWritable, NullWritable>> edges) {
        EdgeIterables.initialize(this, edges);
    }

    @Override
    public void initialize(int capacity) {
        this.neighbors = new LongArrayList(capacity);
    }

    @Override
    public void initialize() {
        this.neighbors = new LongArrayList();
    }

    @Override
    public void add(Edge<LongWritable, NullWritable> edge) {
        this.neighbors.add(edge.getTargetVertexId().get());
    }

    private void trimBack() {
        if (this.neighbors.elements().length > 4 * this.neighbors.size()) {
            this.neighbors.trim(this.neighbors.elements().length / 2);
        }
    }

    private void removeAt(int i) {
        if (i == this.neighbors.size() - 1) {
            this.neighbors.popLong();
        } else {
            this.neighbors.set(i, this.neighbors.popLong());
        }
        this.trimBack();
    }

    @Override
    public void remove(LongWritable targetVertexId) {
        for (int i = this.neighbors.size() - 1; i >= 0; --i) {
            if (this.neighbors.getLong(i) != targetVertexId.get()) continue;
            this.removeAt(i);
        }
    }

    @Override
    public int size() {
        return this.neighbors.size();
    }

    @Override
    public Iterator<Edge<LongWritable, NullWritable>> iterator() {
        return this.mutableIterator();
    }

    @Override
    public Iterator<MutableEdge<LongWritable, NullWritable>> mutableIterator() {
        return new Iterator<MutableEdge<LongWritable, NullWritable>>(){
            private int offset = 0;
            private final MutableEdge<LongWritable, NullWritable> representativeEdge = EdgeFactory.createReusable(new LongWritable());

            @Override
            public boolean hasNext() {
                return this.offset < LongNullArrayEdges.this.neighbors.size();
            }

            @Override
            public MutableEdge<LongWritable, NullWritable> next() {
                ((LongWritable)this.representativeEdge.getTargetVertexId()).set(LongNullArrayEdges.this.neighbors.getLong(this.offset++));
                return this.representativeEdge;
            }

            @Override
            public void remove() {
                LongNullArrayEdges.this.removeAt(--this.offset);
            }
        };
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.neighbors.size());
        LongListIterator neighborsIt = this.neighbors.iterator();
        while (neighborsIt.hasNext()) {
            out.writeLong(neighborsIt.nextLong());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numEdges = in.readInt();
        this.initialize(numEdges);
        for (int i = 0; i < numEdges; ++i) {
            this.neighbors.add(in.readLong());
        }
    }

    @Override
    public void trim() {
        this.neighbors.trim();
    }
}

