/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.edge.DefaultEdge;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.MutableOutEdges;
import org.apache.giraph.edge.ReusableEdge;
import org.apache.giraph.edge.ReuseObjectsOutEdges;
import org.apache.giraph.edge.StrictRandomAccessOutEdges;
import org.apache.giraph.utils.EdgeIterables;
import org.apache.giraph.utils.Trimmable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;

public class LongDoubleHashMapEdges
implements StrictRandomAccessOutEdges<LongWritable, DoubleWritable>,
ReuseObjectsOutEdges<LongWritable, DoubleWritable>,
MutableOutEdges<LongWritable, DoubleWritable>,
Trimmable {
    private Long2DoubleOpenHashMap edgeMap;
    private DoubleWritable representativeEdgeValue;

    @Override
    public void initialize(Iterable<Edge<LongWritable, DoubleWritable>> edges) {
        EdgeIterables.initialize(this, edges);
    }

    @Override
    public void initialize(int capacity) {
        this.edgeMap = new Long2DoubleOpenHashMap(capacity);
    }

    @Override
    public void initialize() {
        this.edgeMap = new Long2DoubleOpenHashMap();
    }

    @Override
    public void add(Edge<LongWritable, DoubleWritable> edge) {
        this.edgeMap.put(edge.getTargetVertexId().get(), edge.getValue().get());
    }

    @Override
    public void remove(LongWritable targetVertexId) {
        this.edgeMap.remove(targetVertexId.get());
    }

    @Override
    public DoubleWritable getEdgeValue(LongWritable targetVertexId) {
        if (!this.edgeMap.containsKey(targetVertexId.get())) {
            return null;
        }
        if (this.representativeEdgeValue == null) {
            this.representativeEdgeValue = new DoubleWritable();
        }
        this.representativeEdgeValue.set(this.edgeMap.get(targetVertexId.get()));
        return this.representativeEdgeValue;
    }

    @Override
    public void setEdgeValue(LongWritable targetVertexId, DoubleWritable edgeValue) {
        if (this.edgeMap.containsKey(targetVertexId.get())) {
            this.edgeMap.put(targetVertexId.get(), edgeValue.get());
        }
    }

    @Override
    public int size() {
        return this.edgeMap.size();
    }

    @Override
    public Iterator<Edge<LongWritable, DoubleWritable>> iterator() {
        return new UnmodifiableIterator<Edge<LongWritable, DoubleWritable>>(){
            private final ObjectIterator<Long2DoubleMap.Entry> mapIterator;
            private final ReusableEdge<LongWritable, DoubleWritable> representativeEdge;
            {
                this.mapIterator = LongDoubleHashMapEdges.this.edgeMap.long2DoubleEntrySet().fastIterator();
                this.representativeEdge = EdgeFactory.createReusable(new LongWritable(), new DoubleWritable());
            }

            public boolean hasNext() {
                return this.mapIterator.hasNext();
            }

            public Edge<LongWritable, DoubleWritable> next() {
                Long2DoubleMap.Entry nextEntry = (Long2DoubleMap.Entry)this.mapIterator.next();
                ((LongWritable)this.representativeEdge.getTargetVertexId()).set(nextEntry.getLongKey());
                ((DoubleWritable)this.representativeEdge.getValue()).set(nextEntry.getDoubleValue());
                return this.representativeEdge;
            }
        };
    }

    @Override
    public void trim() {
        this.edgeMap.trim();
    }

    @Override
    public Iterator<MutableEdge<LongWritable, DoubleWritable>> mutableIterator() {
        return new Iterator<MutableEdge<LongWritable, DoubleWritable>>(){
            private final ObjectIterator<Long2DoubleMap.Entry> mapIterator;
            private final LongDoubleHashMapMutableEdge representativeEdge;
            {
                this.mapIterator = LongDoubleHashMapEdges.this.edgeMap.long2DoubleEntrySet().iterator();
                this.representativeEdge = new LongDoubleHashMapMutableEdge();
            }

            @Override
            public boolean hasNext() {
                return this.mapIterator.hasNext();
            }

            @Override
            public MutableEdge<LongWritable, DoubleWritable> next() {
                this.representativeEdge.setEntry((Long2DoubleMap.Entry)this.mapIterator.next());
                return this.representativeEdge;
            }

            @Override
            public void remove() {
                this.mapIterator.remove();
            }
        };
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.edgeMap.size());
        for (Long2DoubleMap.Entry entry : this.edgeMap.long2DoubleEntrySet()) {
            out.writeLong(entry.getLongKey());
            out.writeDouble(entry.getDoubleValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numEdges = in.readInt();
        this.initialize(numEdges);
        for (int i = 0; i < numEdges; ++i) {
            this.edgeMap.put(in.readLong(), in.readDouble());
        }
    }

    private static class LongDoubleHashMapMutableEdge
    extends DefaultEdge<LongWritable, DoubleWritable> {
        private Long2DoubleMap.Entry entry;

        public LongDoubleHashMapMutableEdge() {
            super(new LongWritable(), new DoubleWritable());
        }

        public void setEntry(Long2DoubleMap.Entry entry) {
            ((LongWritable)this.getTargetVertexId()).set(entry.getLongKey());
            ((DoubleWritable)this.getValue()).set(entry.getDoubleValue());
            this.entry = entry;
        }

        @Override
        public void setValue(DoubleWritable value) {
            ((DoubleWritable)this.getValue()).set(value.get());
            this.entry.setValue(value.get());
        }
    }
}

