/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.edge.DefaultEdge;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.MutableOutEdges;
import org.apache.giraph.edge.ReuseObjectsOutEdges;
import org.apache.giraph.utils.EdgeIterables;
import org.apache.giraph.utils.Trimmable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;

public class LongDoubleArrayEdges
implements ReuseObjectsOutEdges<LongWritable, DoubleWritable>,
MutableOutEdges<LongWritable, DoubleWritable>,
Trimmable {
    private LongArrayList neighbors;
    private DoubleArrayList edgeValues;

    @Override
    public void initialize(Iterable<Edge<LongWritable, DoubleWritable>> edges) {
        EdgeIterables.initialize(this, edges);
    }

    @Override
    public void initialize(int capacity) {
        this.neighbors = new LongArrayList(capacity);
        this.edgeValues = new DoubleArrayList(capacity);
    }

    @Override
    public void initialize() {
        this.neighbors = new LongArrayList();
        this.edgeValues = new DoubleArrayList();
    }

    @Override
    public void add(Edge<LongWritable, DoubleWritable> edge) {
        this.neighbors.add(edge.getTargetVertexId().get());
        this.edgeValues.add(edge.getValue().get());
    }

    private void trimBack() {
        if (this.neighbors.elements().length > 4 * this.neighbors.size()) {
            this.neighbors.trim(this.neighbors.elements().length / 2);
            this.edgeValues.trim(this.neighbors.elements().length / 2);
        }
    }

    private void removeAt(int i) {
        if (i == this.neighbors.size() - 1) {
            this.neighbors.popLong();
            this.edgeValues.popDouble();
        } else {
            this.neighbors.set(i, this.neighbors.popLong());
            this.edgeValues.set(i, this.edgeValues.popDouble());
        }
        this.trimBack();
    }

    @Override
    public void remove(LongWritable targetVertexId) {
        for (int i = this.neighbors.size() - 1; i >= 0; --i) {
            if (this.neighbors.getLong(i) != targetVertexId.get()) continue;
            this.removeAt(i);
        }
    }

    @Override
    public int size() {
        return this.neighbors.size();
    }

    @Override
    public Iterator<Edge<LongWritable, DoubleWritable>> iterator() {
        return new UnmodifiableIterator<Edge<LongWritable, DoubleWritable>>(){
            private final LongIterator neighborsIt;
            private final DoubleIterator edgeValuesIt;
            private final Edge<LongWritable, DoubleWritable> representativeEdge;
            {
                this.neighborsIt = LongDoubleArrayEdges.this.neighbors.iterator();
                this.edgeValuesIt = LongDoubleArrayEdges.this.edgeValues.iterator();
                this.representativeEdge = EdgeFactory.create(new LongWritable(), new DoubleWritable());
            }

            public boolean hasNext() {
                return this.neighborsIt.hasNext();
            }

            public Edge<LongWritable, DoubleWritable> next() {
                this.representativeEdge.getTargetVertexId().set(this.neighborsIt.nextLong());
                this.representativeEdge.getValue().set(this.edgeValuesIt.nextDouble());
                return this.representativeEdge;
            }
        };
    }

    @Override
    public Iterator<MutableEdge<LongWritable, DoubleWritable>> mutableIterator() {
        return new Iterator<MutableEdge<LongWritable, DoubleWritable>>(){
            private int offset = 0;
            private final LongDoubleArrayMutableEdge representativeEdge = new LongDoubleArrayMutableEdge();

            @Override
            public boolean hasNext() {
                return this.offset < LongDoubleArrayEdges.this.neighbors.size();
            }

            @Override
            public MutableEdge<LongWritable, DoubleWritable> next() {
                this.representativeEdge.setIndex(this.offset++);
                return this.representativeEdge;
            }

            @Override
            public void remove() {
                LongDoubleArrayEdges.this.removeAt(--this.offset);
            }
        };
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.neighbors.size());
        LongListIterator neighborsIt = this.neighbors.iterator();
        DoubleListIterator edgeValuesIt = this.edgeValues.iterator();
        while (neighborsIt.hasNext()) {
            out.writeLong(neighborsIt.nextLong());
            out.writeDouble(edgeValuesIt.nextDouble());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numEdges = in.readInt();
        this.initialize(numEdges);
        for (int i = 0; i < numEdges; ++i) {
            this.neighbors.add(in.readLong());
            this.edgeValues.add(in.readDouble());
        }
    }

    @Override
    public void trim() {
        this.neighbors.trim();
        this.edgeValues.trim();
    }

    private class LongDoubleArrayMutableEdge
    extends DefaultEdge<LongWritable, DoubleWritable> {
        private int index;

        public LongDoubleArrayMutableEdge() {
            super(new LongWritable(), new DoubleWritable());
        }

        public void setIndex(int index) {
            ((LongWritable)this.getTargetVertexId()).set(LongDoubleArrayEdges.this.neighbors.getLong(index));
            ((DoubleWritable)this.getValue()).set(LongDoubleArrayEdges.this.edgeValues.getDouble(index));
            this.index = index;
        }

        @Override
        public void setValue(DoubleWritable value) {
            ((DoubleWritable)this.getValue()).set(value.get());
            LongDoubleArrayEdges.this.edgeValues.set(this.index, value.get());
        }
    }
}

