/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.ReuseObjectsOutEdges;
import org.apache.giraph.utils.EdgeIterables;
import org.apache.giraph.utils.Trimmable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;

public class IntNullArrayEdges
implements ReuseObjectsOutEdges<IntWritable, NullWritable>,
Trimmable {
    private IntArrayList neighbors;

    @Override
    public void initialize(Iterable<Edge<IntWritable, NullWritable>> edges) {
        EdgeIterables.initialize(this, edges);
    }

    @Override
    public void initialize(int capacity) {
        this.neighbors = new IntArrayList(capacity);
    }

    @Override
    public void initialize() {
        this.neighbors = new IntArrayList();
    }

    @Override
    public int size() {
        return this.neighbors.size();
    }

    @Override
    public void add(Edge<IntWritable, NullWritable> edge) {
        this.neighbors.add(edge.getTargetVertexId().get());
    }

    private void removeAt(int i) {
        if (i == this.neighbors.size() - 1) {
            this.neighbors.popInt();
        } else {
            this.neighbors.set(i, this.neighbors.popInt());
        }
    }

    @Override
    public void remove(IntWritable targetVertexId) {
        for (int i = this.neighbors.size() - 1; i >= 0; --i) {
            if (this.neighbors.getInt(i) != targetVertexId.get()) continue;
            this.removeAt(i);
        }
    }

    @Override
    public Iterator<Edge<IntWritable, NullWritable>> iterator() {
        return new UnmodifiableIterator<Edge<IntWritable, NullWritable>>(){
            private final IntIterator neighborsIt;
            private final Edge<IntWritable, NullWritable> representativeEdge;
            {
                this.neighborsIt = IntNullArrayEdges.this.neighbors.iterator();
                this.representativeEdge = EdgeFactory.create(new IntWritable(), NullWritable.get());
            }

            public boolean hasNext() {
                return this.neighborsIt.hasNext();
            }

            public Edge<IntWritable, NullWritable> next() {
                this.representativeEdge.getTargetVertexId().set(this.neighborsIt.nextInt());
                return this.representativeEdge;
            }
        };
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.neighbors.size());
        IntListIterator iterator = this.neighbors.iterator();
        while (iterator.hasNext()) {
            out.writeInt(iterator.nextInt());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numEdges = in.readInt();
        this.initialize(numEdges);
        for (int i = 0; i < numEdges; ++i) {
            this.neighbors.add(in.readInt());
        }
    }

    @Override
    public void trim() {
        this.neighbors.trim();
    }
}

