/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.AbstractEdgeStore;
import org.apache.giraph.edge.EdgeStore;
import org.apache.giraph.edge.EdgeStoreFactory;
import org.apache.giraph.edge.SimpleEdgeStore;
import org.apache.giraph.edge.primitives.IntEdgeStore;
import org.apache.giraph.edge.primitives.LongEdgeStore;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.Progressable;

public class InMemoryEdgeStoreFactory<I extends WritableComparable, V extends Writable, E extends Writable>
implements EdgeStoreFactory<I, V, E> {
    protected CentralizedServiceWorker<I, V, E> service;
    protected ImmutableClassesGiraphConfiguration<I, V, E> conf;
    protected Progressable progressable;

    @Override
    public EdgeStore<I, V, E> newStore() {
        Class<I> vertexIdClass = this.conf.getVertexIdClass();
        AbstractEdgeStore edgeStore = vertexIdClass.equals(IntWritable.class) ? new IntEdgeStore<V, E>(this.service, this.conf, this.progressable) : (vertexIdClass.equals(LongWritable.class) ? new LongEdgeStore<V, E>(this.service, this.conf, this.progressable) : new SimpleEdgeStore<I, V, E>(this.service, this.conf, this.progressable));
        return edgeStore;
    }

    @Override
    public void initialize(CentralizedServiceWorker<I, V, E> service, ImmutableClassesGiraphConfiguration<I, V, E> conf, Progressable progressable) {
        this.service = service;
        this.conf = conf;
        this.progressable = progressable;
    }
}

