/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.UnmodifiableIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.conf.ImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.DefaultEdge;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.MutableOutEdges;
import org.apache.giraph.edge.ReuseObjectsOutEdges;
import org.apache.giraph.types.ops.PrimitiveIdTypeOps;
import org.apache.giraph.types.ops.PrimitiveTypeOps;
import org.apache.giraph.types.ops.TypeOpsUtils;
import org.apache.giraph.types.ops.collections.BasicArrayList;
import org.apache.giraph.utils.EdgeIterables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class IdAndValueArrayEdges<I extends WritableComparable, E extends Writable>
implements ReuseObjectsOutEdges<I, E>,
MutableOutEdges<I, E>,
ImmutableClassesGiraphConfigurable<I, Writable, E> {
    private BasicArrayList<I> neighborIds;
    private BasicArrayList<E> neighborEdgeValues;

    @Override
    public ImmutableClassesGiraphConfiguration<I, Writable, E> getConf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration<I, Writable, E> conf) {
        PrimitiveIdTypeOps<I> idTypeOps = TypeOpsUtils.getPrimitiveIdTypeOps(conf.getVertexIdClass());
        this.neighborIds = idTypeOps.createArrayList(10);
        PrimitiveTypeOps<E> edgeTypeOps = TypeOpsUtils.getPrimitiveTypeOps(conf.getEdgeValueClass());
        this.neighborEdgeValues = edgeTypeOps.createArrayList(10);
    }

    @Override
    public void initialize(Iterable<Edge<I, E>> edges) {
        EdgeIterables.initialize(this, edges);
    }

    @Override
    public void initialize(int capacity) {
        this.neighborIds.setCapacity(capacity);
        this.neighborEdgeValues.setCapacity(capacity);
    }

    @Override
    public void initialize() {
        this.initialize(10);
    }

    @Override
    public void add(Edge<I, E> edge) {
        this.neighborIds.add(edge.getTargetVertexId());
        this.neighborEdgeValues.add(edge.getValue());
    }

    private void trim() {
        if (this.neighborIds.capacity() > 4 * this.neighborIds.size()) {
            this.neighborIds.setCapacity(this.neighborIds.size() * 2);
            this.neighborEdgeValues.setCapacity(this.neighborIds.size() * 2);
        }
    }

    private void removeAt(int i) {
        WritableComparable tmpId = (WritableComparable)this.neighborIds.getElementTypeOps().create();
        Writable tmpValue = (Writable)this.neighborEdgeValues.getElementTypeOps().create();
        this.neighborIds.popInto(tmpId);
        this.neighborEdgeValues.popInto(tmpValue);
        if (i != this.neighborIds.size()) {
            this.neighborIds.set(i, tmpId);
            this.neighborEdgeValues.set(i, tmpValue);
        }
        this.trim();
    }

    @Override
    public void remove(I targetVertexId) {
        WritableComparable tmpId = (WritableComparable)this.neighborIds.getElementTypeOps().create();
        for (int i = this.neighborIds.size() - 1; i >= 0; --i) {
            this.neighborIds.getInto(i, tmpId);
            if (!tmpId.equals(targetVertexId)) continue;
            this.removeAt(i);
        }
    }

    @Override
    public int size() {
        return this.neighborIds.size();
    }

    @Override
    public Iterator<Edge<I, E>> iterator() {
        return new UnmodifiableIterator<Edge<I, E>>(){
            private int index;
            private final Edge<I, E> representativeEdge;
            {
                this.representativeEdge = EdgeFactory.create((WritableComparable)IdAndValueArrayEdges.this.neighborIds.getElementTypeOps().create(), (Writable)IdAndValueArrayEdges.this.neighborEdgeValues.getElementTypeOps().create());
            }

            public boolean hasNext() {
                return this.index < IdAndValueArrayEdges.this.neighborIds.size();
            }

            public Edge<I, E> next() {
                IdAndValueArrayEdges.this.neighborIds.getInto(this.index, this.representativeEdge.getTargetVertexId());
                IdAndValueArrayEdges.this.neighborEdgeValues.getInto(this.index, this.representativeEdge.getValue());
                ++this.index;
                return this.representativeEdge;
            }
        };
    }

    @Override
    public Iterator<MutableEdge<I, E>> mutableIterator() {
        return new Iterator<MutableEdge<I, E>>(){
            private int index = 0;
            private final ArrayMutableEdge representativeEdge = new ArrayMutableEdge();

            @Override
            public boolean hasNext() {
                return this.index < IdAndValueArrayEdges.this.neighborIds.size();
            }

            @Override
            public MutableEdge<I, E> next() {
                this.representativeEdge.setIndex(this.index++);
                return this.representativeEdge;
            }

            @Override
            public void remove() {
                IdAndValueArrayEdges.this.removeAt(--this.index);
            }
        };
    }

    public void write(DataOutput out) throws IOException {
        this.neighborIds.write(out);
        this.neighborEdgeValues.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.neighborIds.readFields(in);
        this.neighborEdgeValues.readFields(in);
    }

    private class ArrayMutableEdge
    extends DefaultEdge<I, E> {
        private int index;

        public ArrayMutableEdge() {
            super((WritableComparable)IdAndValueArrayEdges.this.neighborIds.getElementTypeOps().create(), (Writable)IdAndValueArrayEdges.this.neighborEdgeValues.getElementTypeOps().create());
        }

        public void setIndex(int index) {
            IdAndValueArrayEdges.this.neighborIds.getInto(index, this.getTargetVertexId());
            IdAndValueArrayEdges.this.neighborEdgeValues.getInto(index, this.getValue());
            this.index = index;
        }

        @Override
        public void setValue(E value) {
            IdAndValueArrayEdges.this.neighborEdgeValues.getElementTypeOps().set(this.getValue(), value);
            IdAndValueArrayEdges.this.neighborEdgeValues.set(this.index, value);
        }
    }
}

