/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.conf.ImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.MutableOutEdges;
import org.apache.giraph.edge.ReuseObjectsOutEdges;
import org.apache.giraph.types.ops.PrimitiveIdTypeOps;
import org.apache.giraph.types.ops.TypeOpsUtils;
import org.apache.giraph.types.ops.collections.BasicArrayList;
import org.apache.giraph.utils.EdgeIterables;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class IdAndNullArrayEdges<I extends WritableComparable>
implements ReuseObjectsOutEdges<I, NullWritable>,
MutableOutEdges<I, NullWritable>,
ImmutableClassesGiraphConfigurable<I, Writable, NullWritable> {
    private BasicArrayList<I> neighbors;

    @Override
    public ImmutableClassesGiraphConfiguration<I, Writable, NullWritable> getConf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration<I, Writable, NullWritable> conf) {
        PrimitiveIdTypeOps<I> idTypeOps = TypeOpsUtils.getPrimitiveIdTypeOps(conf.getVertexIdClass());
        this.neighbors = idTypeOps.createArrayList(10);
        if (!conf.getEdgeValueClass().equals(NullWritable.class)) {
            throw new IllegalArgumentException("IdAndNullArrayEdges can be used only with NullWritable as edgeValueClass, not with " + conf.getEdgeValueClass());
        }
    }

    @Override
    public void initialize(Iterable<Edge<I, NullWritable>> edges) {
        EdgeIterables.initialize(this, edges);
    }

    @Override
    public void initialize(int capacity) {
        this.neighbors.setCapacity(capacity);
    }

    @Override
    public void initialize() {
        this.initialize(10);
    }

    @Override
    public void add(Edge<I, NullWritable> edge) {
        this.neighbors.add(edge.getTargetVertexId());
    }

    private void trim() {
        if (this.neighbors.capacity() > 4 * this.neighbors.size()) {
            this.neighbors.setCapacity(this.neighbors.size() * 2);
        }
    }

    private void removeAt(int i) {
        WritableComparable tmpValue = (WritableComparable)this.neighbors.getElementTypeOps().create();
        this.neighbors.popInto(tmpValue);
        if (i != this.neighbors.size()) {
            this.neighbors.set(i, tmpValue);
        }
        this.trim();
    }

    @Override
    public void remove(I targetVertexId) {
        WritableComparable tmpValue = (WritableComparable)this.neighbors.getElementTypeOps().create();
        for (int i = this.neighbors.size() - 1; i >= 0; --i) {
            this.neighbors.getInto(i, tmpValue);
            if (!tmpValue.equals(targetVertexId)) continue;
            this.removeAt(i);
        }
    }

    @Override
    public int size() {
        return this.neighbors.size();
    }

    @Override
    public Iterator<Edge<I, NullWritable>> iterator() {
        return this.mutableIterator();
    }

    @Override
    public Iterator<MutableEdge<I, NullWritable>> mutableIterator() {
        return new Iterator<MutableEdge<I, NullWritable>>(){
            private int offset = 0;
            private final MutableEdge<I, NullWritable> representativeEdge = EdgeFactory.createReusable((WritableComparable)IdAndNullArrayEdges.access$000(IdAndNullArrayEdges.this).getElementTypeOps().create());

            @Override
            public boolean hasNext() {
                return this.offset < IdAndNullArrayEdges.this.neighbors.size();
            }

            @Override
            public MutableEdge<I, NullWritable> next() {
                IdAndNullArrayEdges.this.neighbors.getInto(this.offset++, this.representativeEdge.getTargetVertexId());
                return this.representativeEdge;
            }

            @Override
            public void remove() {
                IdAndNullArrayEdges.this.removeAt(--this.offset);
            }
        };
    }

    public void write(DataOutput out) throws IOException {
        this.neighbors.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.neighbors.readFields(in);
    }
}

