/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.UnmodifiableIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.giraph.edge.ConfigurableOutEdges;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.MultiRandomAccessOutEdges;
import org.apache.giraph.edge.ReusableEdge;
import org.apache.giraph.utils.EdgeIterables;
import org.apache.giraph.utils.Trimmable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class HashMultimapEdges<I extends WritableComparable, E extends Writable>
extends ConfigurableOutEdges<I, E>
implements MultiRandomAccessOutEdges<I, E>,
Trimmable {
    private ArrayListMultimap<I, E> edgeMultimap;

    @Override
    public void initialize(Iterable<Edge<I, E>> edges) {
        EdgeIterables.initialize(this, edges);
    }

    public void initialize(int expectedNeighbors, int expectedEdgesPerNeighbor) {
        this.edgeMultimap = ArrayListMultimap.create((int)expectedNeighbors, (int)expectedEdgesPerNeighbor);
    }

    @Override
    public void initialize(int capacity) {
        this.initialize(capacity, 1);
    }

    @Override
    public void initialize() {
        this.edgeMultimap = ArrayListMultimap.create();
    }

    @Override
    public void add(Edge<I, E> edge) {
        this.edgeMultimap.put(edge.getTargetVertexId(), edge.getValue());
    }

    @Override
    public void remove(I targetVertexId) {
        this.edgeMultimap.removeAll(targetVertexId);
    }

    @Override
    public Iterable<E> getAllEdgeValues(I targetVertexId) {
        return this.edgeMultimap.get(targetVertexId);
    }

    @Override
    public int size() {
        return this.edgeMultimap.size();
    }

    @Override
    public Iterator<Edge<I, E>> iterator() {
        return new UnmodifiableIterator<Edge<I, E>>(){
            private Iterator<Map.Entry<I, E>> mapIterator;
            private ReusableEdge<I, E> representativeEdge;
            {
                this.mapIterator = HashMultimapEdges.this.edgeMultimap.entries().iterator();
                this.representativeEdge = HashMultimapEdges.this.getConf().createReusableEdge();
            }

            public boolean hasNext() {
                return this.mapIterator.hasNext();
            }

            public Edge<I, E> next() {
                Map.Entry nextEntry = this.mapIterator.next();
                this.representativeEdge.setTargetVertexId((WritableComparable)nextEntry.getKey());
                this.representativeEdge.setValue((Writable)nextEntry.getValue());
                return this.representativeEdge;
            }
        };
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.edgeMultimap.size());
        out.writeInt(this.edgeMultimap.keys().size());
        for (Map.Entry edge : this.edgeMultimap.entries()) {
            ((WritableComparable)edge.getKey()).write(out);
            ((Writable)edge.getValue()).write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numEdges = in.readInt();
        int numNeighbors = in.readInt();
        this.initialize(numEdges, numNeighbors == 0 ? 0 : numEdges / numNeighbors);
        for (int i = 0; i < numEdges; ++i) {
            Object targetVertexId = this.getConf().createVertexId();
            targetVertexId.readFields(in);
            Object edgeValue = this.getConf().createEdgeValue();
            edgeValue.readFields(in);
            this.edgeMultimap.put(targetVertexId, edgeValue);
        }
    }

    @Override
    public void trim() {
        this.edgeMultimap.trimToSize();
    }
}

