/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.giraph.edge.ConfigurableOutEdges;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.MapMutableEdge;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.MutableOutEdges;
import org.apache.giraph.edge.StrictRandomAccessOutEdges;
import org.apache.giraph.utils.EdgeIterables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class HashMapEdges<I extends WritableComparable, E extends Writable>
extends ConfigurableOutEdges<I, E>
implements StrictRandomAccessOutEdges<I, E>,
MutableOutEdges<I, E> {
    private HashMap<I, E> edgeMap;

    @Override
    public void initialize(Iterable<Edge<I, E>> edges) {
        EdgeIterables.initialize(this, edges);
    }

    @Override
    public void initialize(int capacity) {
        this.edgeMap = Maps.newHashMapWithExpectedSize((int)capacity);
    }

    @Override
    public void initialize() {
        this.edgeMap = Maps.newHashMap();
    }

    @Override
    public void add(Edge<I, E> edge) {
        this.edgeMap.put(edge.getTargetVertexId(), edge.getValue());
    }

    @Override
    public void remove(I targetVertexId) {
        this.edgeMap.remove(targetVertexId);
    }

    @Override
    public E getEdgeValue(I targetVertexId) {
        return (E)((Writable)this.edgeMap.get(targetVertexId));
    }

    @Override
    public void setEdgeValue(I targetVertexId, E edgeValue) {
        if (this.edgeMap.containsKey(targetVertexId)) {
            this.edgeMap.put(targetVertexId, edgeValue);
        }
    }

    @Override
    public int size() {
        return this.edgeMap.size();
    }

    @Override
    public Iterator<Edge<I, E>> iterator() {
        return this.mutableIterator();
    }

    @Override
    public Iterator<MutableEdge<I, E>> mutableIterator() {
        return new Iterator<MutableEdge<I, E>>(){
            private Iterator<Map.Entry<I, E>> mapIterator;
            private MapMutableEdge<I, E> representativeEdge;
            {
                this.mapIterator = HashMapEdges.this.edgeMap.entrySet().iterator();
                this.representativeEdge = new MapMutableEdge();
            }

            @Override
            public boolean hasNext() {
                return this.mapIterator.hasNext();
            }

            @Override
            public MutableEdge<I, E> next() {
                this.representativeEdge.setEntry(this.mapIterator.next());
                return this.representativeEdge;
            }

            @Override
            public void remove() {
                this.mapIterator.remove();
            }
        };
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.edgeMap.size());
        for (Map.Entry<I, E> entry : this.edgeMap.entrySet()) {
            ((WritableComparable)entry.getKey()).write(out);
            ((Writable)entry.getValue()).write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numEdges = in.readInt();
        this.initialize(numEdges);
        for (int i = 0; i < numEdges; ++i) {
            Object targetVertexId = this.getConf().createVertexId();
            targetVertexId.readFields(in);
            Object edgeValue = this.getConf().createEdgeValue();
            edgeValue.readFields(in);
            this.edgeMap.put(targetVertexId, edgeValue);
        }
    }
}

