/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import org.apache.giraph.edge.DefaultEdge;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeNoValue;
import org.apache.giraph.edge.ReusableEdge;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class EdgeFactory {
    private EdgeFactory() {
    }

    public static <I extends WritableComparable, E extends Writable> Edge<I, E> create(I id, E value) {
        return EdgeFactory.createReusable(id, value);
    }

    public static <I extends WritableComparable> Edge<I, NullWritable> create(I id) {
        return EdgeFactory.createReusable(id);
    }

    public static <I extends WritableComparable, E extends Writable> ReusableEdge<I, E> createReusable(I id, E value) {
        if (value instanceof NullWritable) {
            return EdgeFactory.createReusable(id);
        }
        return new DefaultEdge<I, E>(id, value);
    }

    public static <I extends WritableComparable> ReusableEdge<I, NullWritable> createReusable(I id) {
        return new EdgeNoValue<I>(id);
    }
}

