/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.giraph.edge.ConfigurableOutEdges;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.ReusableEdge;
import org.apache.giraph.edge.ReuseObjectsOutEdges;
import org.apache.giraph.utils.ExtendedDataInput;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.Trimmable;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class ByteArrayEdges<I extends WritableComparable, E extends Writable>
extends ConfigurableOutEdges<I, E>
implements ReuseObjectsOutEdges<I, E>,
Trimmable {
    private byte[] serializedEdges;
    private int serializedEdgesBytesUsed;
    private int edgeCount;

    @Override
    public void initialize(Iterable<Edge<I, E>> edges) {
        ExtendedDataOutput extendedOutputStream = this.getConf().createExtendedDataOutput();
        for (Edge<I, E> edge : edges) {
            try {
                WritableUtils.writeEdge(extendedOutputStream, edge);
            }
            catch (IOException e) {
                throw new IllegalStateException("initialize: Failed to serialize " + edge);
            }
            ++this.edgeCount;
        }
        this.serializedEdges = extendedOutputStream.getByteArray();
        this.serializedEdgesBytesUsed = extendedOutputStream.getPos();
    }

    @Override
    public void initialize(int capacity) {
        this.initialize();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void add(Edge<I, E> edge) {
        ExtendedDataOutput extendedDataOutput = this.getConf().createExtendedDataOutput(this.serializedEdges, this.serializedEdgesBytesUsed);
        try {
            WritableUtils.writeEdge(extendedDataOutput, edge);
        }
        catch (IOException e) {
            throw new IllegalStateException("add: Failed to write to the new byte array");
        }
        this.serializedEdges = extendedDataOutput.getByteArray();
        this.serializedEdgesBytesUsed = extendedDataOutput.getPos();
        ++this.edgeCount;
    }

    @Override
    public void remove(I targetVertexId) {
        ByteArrayEdgeIterator iterator = new ByteArrayEdgeIterator();
        LinkedList<Integer> foundStartOffsets = new LinkedList<Integer>();
        LinkedList<Integer> foundEndOffsets = new LinkedList<Integer>();
        int lastStartOffset = 0;
        while (iterator.hasNext()) {
            Object edge = iterator.next();
            if (edge.getTargetVertexId().equals(targetVertexId)) {
                foundStartOffsets.add(lastStartOffset);
                foundEndOffsets.add(iterator.extendedDataInput.getPos());
                --this.edgeCount;
            }
            lastStartOffset = iterator.extendedDataInput.getPos();
        }
        foundStartOffsets.add(this.serializedEdgesBytesUsed);
        Iterator foundStartOffsetIter = foundStartOffsets.iterator();
        Integer foundStartOffset = (Integer)foundStartOffsetIter.next();
        for (Integer foundEndOffset : foundEndOffsets) {
            Integer nextFoundStartOffset = (Integer)foundStartOffsetIter.next();
            System.arraycopy(this.serializedEdges, foundEndOffset, this.serializedEdges, foundStartOffset, nextFoundStartOffset - foundEndOffset);
            this.serializedEdgesBytesUsed -= foundEndOffset - foundStartOffset;
            foundStartOffset = nextFoundStartOffset;
        }
    }

    @Override
    public int size() {
        return this.edgeCount;
    }

    @Override
    public void trim() {
        if (this.serializedEdges != null && this.serializedEdges.length > this.serializedEdgesBytesUsed) {
            this.serializedEdges = Arrays.copyOf(this.serializedEdges, this.serializedEdgesBytesUsed);
        }
    }

    @Override
    public Iterator<Edge<I, E>> iterator() {
        if (this.edgeCount == 0) {
            return Iterators.emptyIterator();
        }
        return new ByteArrayEdgeIterator();
    }

    public void readFields(DataInput in) throws IOException {
        this.serializedEdgesBytesUsed = in.readInt();
        if (this.serializedEdgesBytesUsed > 0) {
            if (this.serializedEdges == null || this.serializedEdgesBytesUsed > this.serializedEdges.length) {
                this.serializedEdges = new byte[this.serializedEdgesBytesUsed];
            }
            in.readFully(this.serializedEdges, 0, this.serializedEdgesBytesUsed);
        }
        this.edgeCount = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.serializedEdgesBytesUsed);
        if (this.serializedEdgesBytesUsed > 0) {
            out.write(this.serializedEdges, 0, this.serializedEdgesBytesUsed);
        }
        out.writeInt(this.edgeCount);
    }

    private class ByteArrayEdgeIterator
    extends UnmodifiableIterator<Edge<I, E>> {
        private ExtendedDataInput extendedDataInput;
        private ReusableEdge<I, E> representativeEdge;

        private ByteArrayEdgeIterator() {
            this.extendedDataInput = ByteArrayEdges.this.getConf().createExtendedDataInput(ByteArrayEdges.this.serializedEdges, 0, ByteArrayEdges.this.serializedEdgesBytesUsed);
            this.representativeEdge = ByteArrayEdges.this.getConf().createReusableEdge();
        }

        public boolean hasNext() {
            return ByteArrayEdges.this.serializedEdges != null && !this.extendedDataInput.endOfInput();
        }

        public Edge<I, E> next() {
            try {
                WritableUtils.readEdge(this.extendedDataInput, this.representativeEdge);
            }
            catch (IOException e) {
                throw new IllegalStateException("next: Failed on pos " + this.extendedDataInput.getPos() + " edge " + this.representativeEdge);
            }
            return this.representativeEdge;
        }
    }
}

