/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.giraph.edge.ConfigurableOutEdges;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.MutableOutEdges;
import org.apache.giraph.utils.Trimmable;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class ArrayListEdges<I extends WritableComparable, E extends Writable>
extends ConfigurableOutEdges<I, E>
implements MutableOutEdges<I, E>,
Trimmable {
    private ArrayList<Edge<I, E>> edgeList;

    @Override
    public void initialize(Iterable<Edge<I, E>> edges) {
        this.edgeList = edges instanceof ArrayList ? (ArrayList)edges : Lists.newArrayList(edges);
    }

    @Override
    public void initialize(int capacity) {
        this.edgeList = Lists.newArrayListWithCapacity((int)capacity);
    }

    @Override
    public void initialize() {
        this.edgeList = Lists.newArrayList();
    }

    @Override
    public void add(Edge<I, E> edge) {
        this.edgeList.add(edge);
    }

    @Override
    public void remove(I targetVertexId) {
        Iterator<Edge<I, E>> edges = this.edgeList.iterator();
        while (edges.hasNext()) {
            Edge<I, E> edge = edges.next();
            if (!edge.getTargetVertexId().equals(targetVertexId)) continue;
            edges.remove();
        }
    }

    @Override
    public int size() {
        return this.edgeList.size();
    }

    @Override
    public final Iterator<Edge<I, E>> iterator() {
        return this.edgeList.iterator();
    }

    @Override
    public Iterator<MutableEdge<I, E>> mutableIterator() {
        return this.iterator();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.edgeList.size());
        for (Edge<I, E> edge : this.edgeList) {
            edge.getTargetVertexId().write(out);
            edge.getValue().write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numEdges = in.readInt();
        this.initialize(numEdges);
        for (int i = 0; i < numEdges; ++i) {
            Edge edge = this.getConf().createEdge();
            WritableUtils.readEdge(in, edge);
            this.edgeList.add(edge);
        }
    }

    @Override
    public void trim() {
        this.edgeList.trimToSize();
    }
}

