/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.MapMaker;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeStore;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.utils.CallableFactory;
import org.apache.giraph.utils.ProgressableUtils;
import org.apache.giraph.utils.VertexIdEdgeIterator;
import org.apache.giraph.utils.VertexIdEdges;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public abstract class AbstractEdgeStore<I extends WritableComparable, V extends Writable, E extends Writable, K, Et>
extends DefaultImmutableClassesGiraphConfigurable<I, V, E>
implements EdgeStore<I, V, E> {
    private static final Logger LOG = Logger.getLogger(AbstractEdgeStore.class);
    protected CentralizedServiceWorker<I, V, E> service;
    protected ImmutableClassesGiraphConfiguration<I, V, E> configuration;
    protected Progressable progressable;
    protected ConcurrentMap<Integer, Map<K, OutEdges<I, E>>> transientEdges;
    protected boolean reuseEdgeObjects;
    protected boolean useInputOutEdges;

    public AbstractEdgeStore(CentralizedServiceWorker<I, V, E> service, ImmutableClassesGiraphConfiguration<I, V, E> configuration, Progressable progressable) {
        this.service = service;
        this.configuration = configuration;
        this.progressable = progressable;
        this.transientEdges = new MapMaker().concurrencyLevel(configuration.getNettyServerExecutionConcurrency()).makeMap();
        this.reuseEdgeObjects = configuration.reuseEdgeObjects();
        this.useInputOutEdges = configuration.useInputOutEdges();
    }

    protected abstract I getVertexId(Et var1, I var2);

    protected abstract I createVertexId(Et var1);

    protected abstract Map<K, OutEdges<I, E>> getPartitionEdges(int var1);

    protected abstract OutEdges<I, E> getPartitionEdges(Et var1);

    protected abstract Iterator<Et> getPartitionEdgesIterator(Map<K, OutEdges<I, E>> var1);

    protected abstract OutEdges<I, E> getVertexOutEdges(VertexIdEdgeIterator<I, E> var1, Map<K, OutEdges<I, E>> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionEdges(int partitionId, VertexIdEdges<I, E> edges) {
        Map<K, OutEdges<I, E>> partitionEdges = this.getPartitionEdges(partitionId);
        VertexIdEdgeIterator<I, E> vertexIdEdgeIterator = edges.getVertexIdEdgeIterator();
        while (vertexIdEdgeIterator.hasNext()) {
            OutEdges<I, E> outEdges;
            vertexIdEdgeIterator.next();
            Edge<I, E> edge = this.reuseEdgeObjects ? vertexIdEdgeIterator.getCurrentEdge() : vertexIdEdgeIterator.releaseCurrentEdge();
            OutEdges<I, E> outEdges2 = outEdges = this.getVertexOutEdges(vertexIdEdgeIterator, partitionEdges);
            synchronized (outEdges2) {
                outEdges.add(edge);
            }
        }
    }

    private OutEdges<I, E> convertInputToComputeEdges(OutEdges<I, E> inputEdges) {
        if (!this.useInputOutEdges) {
            return inputEdges;
        }
        return this.configuration.createAndInitializeOutEdges(inputEdges);
    }

    @Override
    public void moveEdgesToVertices() {
        final boolean createSourceVertex = this.configuration.getCreateSourceVertex();
        if (this.transientEdges.isEmpty()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"moveEdgesToVertices: No edges to move");
            }
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"moveEdgesToVertices: Moving incoming edges to vertices.");
        }
        final ArrayBlockingQueue partitionIdQueue = new ArrayBlockingQueue(this.transientEdges.size());
        partitionIdQueue.addAll(this.transientEdges.keySet());
        int numThreads = this.configuration.getNumInputSplitsThreads();
        CallableFactory<Void> callableFactory = new CallableFactory<Void>(){

            @Override
            public Callable<Void> newCallable(int callableId) {
                return new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Integer partitionId;
                        Object representativeVertexId = AbstractEdgeStore.this.configuration.createVertexId();
                        while ((partitionId = (Integer)partitionIdQueue.poll()) != null) {
                            Partition partition = AbstractEdgeStore.this.service.getPartitionStore().getOrCreatePartition(partitionId);
                            Map partitionEdges = (Map)AbstractEdgeStore.this.transientEdges.remove(partitionId);
                            Iterator iterator = AbstractEdgeStore.this.getPartitionEdgesIterator(partitionEdges);
                            while (iterator.hasNext()) {
                                Object entry = iterator.next();
                                Object vertexId = AbstractEdgeStore.this.getVertexId(entry, representativeVertexId);
                                OutEdges outEdges = AbstractEdgeStore.this.convertInputToComputeEdges(AbstractEdgeStore.this.getPartitionEdges(entry));
                                Vertex vertex = partition.getVertex(vertexId);
                                if (vertex == null) {
                                    if (createSourceVertex) {
                                        vertex = AbstractEdgeStore.this.configuration.createVertex();
                                        vertex.initialize(AbstractEdgeStore.this.createVertexId(entry), AbstractEdgeStore.this.configuration.createVertexValue(), outEdges);
                                        partition.putVertex(vertex);
                                    }
                                } else {
                                    if (vertex.getNumEdges() == 0) {
                                        vertex.setEdges(outEdges);
                                    } else {
                                        for (Edge edge : outEdges) {
                                            vertex.addEdge(edge);
                                        }
                                    }
                                    partition.saveVertex(vertex);
                                }
                                iterator.remove();
                            }
                            AbstractEdgeStore.this.service.getPartitionStore().putPartition(partition);
                        }
                        return null;
                    }
                };
            }
        };
        ProgressableUtils.getResultsWithNCallables(callableFactory, numThreads, "move-edges-%d", this.progressable);
        this.transientEdges.clear();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"moveEdgesToVertices: Finished moving incoming edges to vertices.");
        }
    }
}

