/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.counters;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.giraph.counters.GiraphHadoopCounter;
import org.apache.giraph.counters.HadoopCountersBase;
import org.apache.hadoop.mapreduce.Mapper;

public class GiraphTimers
extends HadoopCountersBase {
    public static final String GROUP_NAME = "Giraph Timers";
    public static final String SETUP_MS_NAME = "Setup (ms)";
    public static final String TOTAL_MS_NAME = "Total (ms)";
    public static final String SHUTDOWN_MS_NAME = "Shutdown (ms)";
    public static final String INITIALIZE_MS_NAME = "Initialize (ms)";
    private static GiraphTimers INSTANCE;
    private static final int SETUP_MS = 0;
    private static final int TOTAL_MS = 1;
    private static final int SHUTDOWN_MS = 2;
    private static final int INITIALIZE_MS = 3;
    private static final int NUM_COUNTERS = 4;
    private final Map<Long, GiraphHadoopCounter> superstepMsec;
    private final GiraphHadoopCounter[] jobCounters = new GiraphHadoopCounter[4];

    private GiraphTimers(Mapper.Context context) {
        super(context, GROUP_NAME);
        this.jobCounters[0] = this.getCounter(SETUP_MS_NAME);
        this.jobCounters[1] = this.getCounter(TOTAL_MS_NAME);
        this.jobCounters[2] = this.getCounter(SHUTDOWN_MS_NAME);
        this.jobCounters[3] = this.getCounter(INITIALIZE_MS_NAME);
        this.superstepMsec = Maps.newHashMap();
    }

    public static void init(Mapper.Context context) {
        INSTANCE = new GiraphTimers(context);
    }

    public static GiraphTimers getInstance() {
        return INSTANCE;
    }

    public GiraphHadoopCounter getSetupMs() {
        return this.jobCounters[0];
    }

    public GiraphHadoopCounter getSuperstepMs(long superstep, String computationName) {
        GiraphHadoopCounter counter = this.superstepMsec.get(superstep);
        if (counter == null) {
            String counterPrefix = superstep == -1L ? "Input superstep" : "Superstep " + superstep + (computationName == null ? "" : " " + computationName);
            counter = this.getCounter(counterPrefix + " (ms)");
            this.superstepMsec.put(superstep, counter);
        }
        return counter;
    }

    public GiraphHadoopCounter getTotalMs() {
        return this.jobCounters[1];
    }

    public GiraphHadoopCounter getShutdownMs() {
        return this.jobCounters[2];
    }

    public GiraphHadoopCounter getInitializeMs() {
        return this.jobCounters[3];
    }

    public Map<Long, GiraphHadoopCounter> superstepCounters() {
        return this.superstepMsec;
    }

    public Iterable<GiraphHadoopCounter> jobCounters() {
        return Arrays.asList(this.jobCounters);
    }

    @Override
    public Iterator<GiraphHadoopCounter> iterator() {
        return Iterators.concat(this.jobCounters().iterator(), this.superstepCounters().values().iterator());
    }
}

