/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.counters;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.giraph.counters.GiraphHadoopCounter;
import org.apache.giraph.counters.HadoopCountersBase;
import org.apache.hadoop.mapreduce.Mapper;

public class GiraphStats
extends HadoopCountersBase {
    public static final String GROUP_NAME = "Giraph Stats";
    public static final String SUPERSTEP_NAME = "Superstep";
    public static final String VERTICES_NAME = "Aggregate vertices";
    public static final String FINISHED_VERTICES_NAME = "Aggregate finished vertices";
    public static final String EDGES_NAME = "Aggregate edges";
    public static final String SENT_MESSAGES_NAME = "Sent messages";
    public static final String SENT_MESSAGE_BYTES_NAME = "Sent message bytes";
    public static final String AGGREGATE_SENT_MESSAGES_NAME = "Aggregate sent messages";
    public static final String AGGREGATE_SENT_MESSAGE_BYTES_NAME = "Aggregate sent message message bytes";
    public static final String CURRENT_WORKERS_NAME = "Current workers";
    public static final String CURRENT_MASTER_PARTITION_TASK_NAME = "Current master task partition";
    public static final String LAST_CHECKPOINTED_SUPERSTEP_NAME = "Last checkpointed superstep";
    private static GiraphStats INSTANCE;
    private static final int SUPERSTEP = 0;
    private static final int VERTICES = 1;
    private static final int FINISHED_VERTICES = 2;
    private static final int EDGES = 3;
    private static final int SENT_MESSAGES = 4;
    private static final int CURRENT_WORKERS = 5;
    private static final int CURRENT_MASTER_TASK_PARTITION = 6;
    private static final int LAST_CHECKPOINTED_SUPERSTEP = 7;
    private static final int SENT_MESSAGE_BYTES = 8;
    private static final int AGG_SENT_MESSAGES = 9;
    private static final int AGG_SENT_MESSAGE_BYTES = 10;
    private static final int NUM_COUNTERS = 11;
    private final GiraphHadoopCounter[] counters = new GiraphHadoopCounter[11];

    private GiraphStats(Mapper.Context context) {
        super(context, GROUP_NAME);
        this.counters[0] = this.getCounter(SUPERSTEP_NAME);
        this.counters[1] = this.getCounter(VERTICES_NAME);
        this.counters[2] = this.getCounter(FINISHED_VERTICES_NAME);
        this.counters[3] = this.getCounter(EDGES_NAME);
        this.counters[4] = this.getCounter(SENT_MESSAGES_NAME);
        this.counters[8] = this.getCounter(SENT_MESSAGE_BYTES_NAME);
        this.counters[5] = this.getCounter(CURRENT_WORKERS_NAME);
        this.counters[6] = this.getCounter(CURRENT_MASTER_PARTITION_TASK_NAME);
        this.counters[7] = this.getCounter(LAST_CHECKPOINTED_SUPERSTEP_NAME);
        this.counters[9] = this.getCounter(AGGREGATE_SENT_MESSAGES_NAME);
        this.counters[10] = this.getCounter(AGGREGATE_SENT_MESSAGE_BYTES_NAME);
    }

    public static void init(Mapper.Context context) {
        INSTANCE = new GiraphStats(context);
    }

    public static GiraphStats getInstance() {
        return INSTANCE;
    }

    public GiraphHadoopCounter getSuperstepCounter() {
        return this.counters[0];
    }

    public GiraphHadoopCounter getVertices() {
        return this.counters[1];
    }

    public GiraphHadoopCounter getFinishedVertexes() {
        return this.counters[2];
    }

    public GiraphHadoopCounter getEdges() {
        return this.counters[3];
    }

    public GiraphHadoopCounter getSentMessages() {
        return this.counters[4];
    }

    public GiraphHadoopCounter getSentMessageBytes() {
        return this.counters[8];
    }

    public GiraphHadoopCounter getAggregateSentMessages() {
        return this.counters[9];
    }

    public GiraphHadoopCounter getAggregateSentMessageBytes() {
        return this.counters[10];
    }

    public GiraphHadoopCounter getCurrentWorkers() {
        return this.counters[5];
    }

    public GiraphHadoopCounter getCurrentMasterTaskPartition() {
        return this.counters[6];
    }

    public GiraphHadoopCounter getLastCheckpointedSuperstep() {
        return this.counters[7];
    }

    @Override
    public Iterator<GiraphHadoopCounter> iterator() {
        return Arrays.asList(this.counters).iterator();
    }
}

