/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.counters;

import com.google.common.base.Objects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.mapreduce.Counter;

public class GiraphHadoopCounter {
    private Counter counter;

    public GiraphHadoopCounter(Counter counter) {
        this.counter = counter;
    }

    public Counter getHadoopCounter() {
        return this.counter;
    }

    public int hashCode() {
        return this.counter.hashCode();
    }

    public boolean equals(Object genericRight) {
        if (genericRight == null) {
            return false;
        }
        if (this.getClass() != genericRight.getClass()) {
            return false;
        }
        GiraphHadoopCounter right = (GiraphHadoopCounter)genericRight;
        return Objects.equal((Object)this.counter, (Object)right.counter);
    }

    public void setValue(long value) {
        this.increment(value - this.getValue());
    }

    public void increment() {
        this.increment(1L);
    }

    public void increment(long incr) {
        this.counter.increment(incr);
    }

    public long getValue() {
        return this.counter.getValue();
    }

    public String getDisplayName() {
        return this.counter.getDisplayName();
    }

    public String getName() {
        return this.counter.getName();
    }

    public void write(DataOutput out) throws IOException {
        this.counter.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.counter.readFields(in);
    }
}

