/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.giraph.conf.AbstractConfOption;
import org.apache.giraph.conf.AllOptions;
import org.apache.giraph.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;

public class StrConfOption
extends AbstractConfOption {
    private final String defaultValue;

    public StrConfOption(String key, String defaultValue, String description) {
        super(key, description);
        this.defaultValue = defaultValue;
        AllOptions.add(this);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isDefaultValue(Configuration conf) {
        return Objects.equal((Object)this.get(conf), (Object)this.defaultValue);
    }

    @Override
    public String getDefaultValueStr() {
        return this.defaultValue;
    }

    @Override
    public ConfOptionType getType() {
        return ConfOptionType.STRING;
    }

    public String get(Configuration conf) {
        return conf.get(this.getKey(), this.defaultValue);
    }

    public String getWithDefault(Configuration conf, String defaultVal) {
        return conf.get(this.getKey(), defaultVal);
    }

    public String[] getArray(Configuration conf) {
        return conf.getStrings(this.getKey(), new String[]{this.defaultValue});
    }

    public List<String> getList(Configuration conf) {
        return Lists.newArrayList((Object[])this.getArray(conf));
    }

    public void set(Configuration conf, String value) {
        conf.set(this.getKey(), value);
    }

    public void setIfUnset(Configuration conf, String value) {
        conf.setIfUnset(this.getKey(), value);
    }
}

